% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.NeuralGAM.R
\name{plot.neuralGAM}
\alias{plot.neuralGAM}
\title{Visualization of \code{neuralGAM} object with base graphics}
\usage{
\method{plot}{neuralGAM}(
  x,
  select = NULL,
  xlab = NULL,
  ylab = NULL,
  interval = c("none", "confidence", "prediction", "both"),
  level = 0.95,
  ...
)
}
\arguments{
\item{x}{A fitted \code{neuralGAM} object as produced by \code{neuralGAM()}.}

\item{select}{Character vector of terms to plot. If \code{NULL} (default),
all terms are plotted.}

\item{xlab}{Optional custom x-axis label(s).}

\item{ylab}{Optional custom y-axis label(s).}

\item{interval}{One of \code{c("none","confidence","prediction","both")}.
Default \code{"none"}. Controls whether intervals are plotted.}

\item{level}{Coverage level for intervals (e.g. \code{0.95}). Default \code{0.95}.}

\item{...}{Additional graphical arguments passed to \code{plot()}.}
}
\value{
Produces plots on the current graphics device.
}
\description{
Visualization of a fitted \code{neuralGAM}. Plots learned partial effects, either as
scatter/line plots for continuous covariates or s for factor covariates.
Confidence and/or prediction intervals can be added if available.
}
\author{
Ines Ortega-Fernandez, Marta Sestelo.
}
