% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustervol.R
\name{as-ClusteredNeuroVol-DenseNeuroVol}
\alias{as-ClusteredNeuroVol-DenseNeuroVol}
\alias{coerce,ClusteredNeuroVol,DenseNeuroVol-method}
\title{Convert ClusteredNeuroVol to DenseNeuroVol}
\arguments{
\item{from}{A \code{\linkS4class{ClusteredNeuroVol}} object to be converted}
}
\value{
A \code{\linkS4class{DenseNeuroVol}} object
}
\description{
This method converts a ClusteredNeuroVol into an equivalent DenseNeuroVol object.
}
\details{
Convert a ClusteredNeuroVol Object to a DenseNeuroVol Object
}
\examples{

# Create a clustered volume
mask <- read_vol(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))
clusters <- rep(1:5, length.out=sum(mask))
cvol <- ClusteredNeuroVol(mask, clusters)

# Convert to DenseNeuroVol
dvol <- as(cvol, "DenseNeuroVol")

}
\seealso{
\code{\linkS4class{ClusteredNeuroVol}}, \code{\linkS4class{DenseNeuroVol}}
}
