% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{quaternToMatrix}
\alias{quaternToMatrix}
\title{Convert Quaternion Parameters to a Transformation Matrix}
\usage{
quaternToMatrix(quat, origin, stepSize, qfac)
}
\arguments{
\item{quat}{A numeric vector of length 3 containing the quaternion parameters
\eqn{(b, c, d)}. The scalar part \eqn{a} is computed internally.}

\item{origin}{A numeric vector of length 3 specifying the translation components
(often the real-space origin or offset).}

\item{stepSize}{A numeric vector of length 3 giving the voxel dimensions along
each axis (e.g., \code{(dx, dy, dz)}).}

\item{qfac}{Either \code{+1} or \code{-1}, indicating the sign from the
determinant check in \code{\link{matrixToQuatern}}.}
}
\value{
A 4x4 numeric affine transformation matrix. The top-left 3x3 submatrix
  encodes rotation and scaling, and the 4th column encodes translation.
}
\description{
Given a quaternion \code{(b, c, d)}, a scalar offset (origin), voxel step sizes,
and the \code{qfac} sign, reconstructs a 4x4 affine matrix representing rotation,
scaling, and translation as used in NIfTI-1.
}
\details{
This function uses the quaternion formalism common in neuroimaging, adding the
offset (translation) into the 4th column, and applying the voxel sizes along
each axis. If \code{qfac} is \code{-1}, the \eqn{z} scale is negated. The
resulting 4x4 matrix is typically used as an affine transform for voxel-to-world
coordinate mapping.
}
\seealso{
\code{\link{matrixToQuatern}} for converting a matrix back to quaternion form.
}
