% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TeamEDGE.R
\name{team_edge_summary}
\alias{team_edge_summary}
\title{Access the EDGE summary for a team, season, and game type}
\usage{
team_edge_summary(team = 1, season = "now", game_type = "")
}
\arguments{
\item{team}{integer ID (e.g., 21), character full name (e.g., 'Colorado
Avalanche'), OR three-letter code (e.g., 'COL'); see \code{\link[=teams]{teams()}} for
reference; ID is preferable as there now exists duplicate three-letter codes
(i.e., 'UTA' for 'Utah Hockey Club' and 'Utah Mammoth')}

\item{season}{integer in YYYYYYYY (e.g., 20242025); see
\code{\link[=team_edge_seasons]{team_edge_seasons()}} for reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
'playoff'/'post'; see \code{\link[=team_edge_seasons]{team_edge_seasons()}} for reference; most functions
will NOT support pre-season}
}
\value{
list of various items
}
\description{
\code{team_edge_summary()} scrapes the EDGE summary for a given set of \code{team},
\code{season}, and \code{game_type}.
}
\examples{
COL_EDGE_summary_regular_20242025 <- team_edge_summary(
  team      = 21, 
  season    = 20242025,
  game_type = 2
)
}
