#######################################################################
# nuggets: An R framework for exploration of patterns in data
# Copyright (C) 2025 Michal Burda
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <https://www.gnu.org/licenses/>.
#######################################################################


test_that("remove_ill_conditions", {
    d <- data.frame(a = 1:5, b = 1:5, bla = 1:5)

    expect_equal(remove_ill_conditions(list(), d),
                 list())
    expect_equal(remove_ill_conditions(list(NULL, NULL), d),
                 list(NULL, NULL))
    expect_equal(remove_ill_conditions(list("a", NULL, c("b", "bla"), "x", c("a", "b", "zz"), "b"), d),
                 list("a", NULL, c("b", "bla"), "b"))

})
