% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatstream.R
\name{DataStream}
\alias{DataStream}
\title{DataStream Class}
\description{
DataStream Class

DataStream Class
}
\details{
A R6 class to manage data streams.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{next_value}}{The next data value from the DataStream or an error message.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataStream-new}{\code{DataStream$new()}}
\item \href{#method-DataStream-close}{\code{DataStream$close()}}
\item \href{#method-DataStream-get_state}{\code{DataStream$get_state()}}
\item \href{#method-DataStream-clone}{\code{DataStream$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStream-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataStream-new}{}}}
\subsection{Method \code{new()}}{
Initialize the DataStream object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStream$new(requery, num = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{requery}}{The requery object, usually of class 'curl'}

\item{\code{num}}{Numeric. Defines the number of lines to read from the data source.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStream-close"></a>}}
\if{latex}{\out{\hypertarget{method-DataStream-close}{}}}
\subsection{Method \code{close()}}{
Close the DataStream

This method tries to destroy the object, and closes the requery if opened.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStream$close()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character message indicating the status of the close operation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStream-get_state"></a>}}
\if{latex}{\out{\hypertarget{method-DataStream-get_state}{}}}
\subsection{Method \code{get_state()}}{
Get the status of the DataStream
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStream$get_state()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character string indicating the current status of the DataStream.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStream-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataStream-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStream$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
