% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_fill}
\alias{wb_add_fill}
\title{Modify the background fill color in a cell region}
\usage{
wb_add_fill(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  color = wb_color(hex = "FFFFFF00"),
  pattern = "solid",
  gradient_fill = "",
  every_nth_col = 1,
  every_nth_row = 1,
  bg_color = NULL,
  ...
)
}
\arguments{
\item{wb}{a workbook}

\item{sheet}{the worksheet}

\item{dims}{the cell range}

\item{color}{the colors to apply, e.g. yellow: wb_color(hex = "FFFFFF00")}

\item{pattern}{various default "none" but others are possible:
"solid", "mediumGray", "darkGray", "lightGray", "darkHorizontal",
"darkVertical", "darkDown", "darkUp", "darkGrid", "darkTrellis",
"lightHorizontal", "lightVertical", "lightDown", "lightUp", "lightGrid",
"lightTrellis", "gray125", "gray0625"}

\item{gradient_fill}{a gradient fill xml pattern.}

\item{every_nth_col}{which col should be filled}

\item{every_nth_row}{which row should be filled}

\item{bg_color}{(optional) background \code{\link[=wb_color]{wb_color()}}}

\item{...}{...}
}
\value{
The \code{wbWorkbook} object, invisibly
}
\description{
Add fill to a cell region.
Setting \code{color} to \code{NULL} removes the style and resets the cell to the workbook default.
}
\examples{
wb <- wb_workbook()
wb <- wb_add_worksheet(wb, "S1")
wb <- wb_add_data(wb, "S1", mtcars)
wb <- wb_add_fill(wb, "S1", dims = "D5:J23", color = wb_color(hex = "FFFFFF00"))
wb <- wb_add_fill(wb, "S1", dims = "B22:D27", color = wb_color(hex = "FF00FF00"))

wb <- wb_add_worksheet(wb, "S2")
wb <- wb_add_data(wb, "S2", mtcars)

gradient_fill1 <- '<gradientFill degree="90">
<stop position="0"><color rgb="FF92D050"/></stop>
<stop position="1"><color rgb="FF0070C0"/></stop>
</gradientFill>'
wb <- wb_add_fill(wb, "S2", dims = "A2:K5", gradient_fill = gradient_fill1)

gradient_fill2 <- '<gradientFill type="path" left="0.2" right="0.8" top="0.2" bottom="0.8">
<stop position="0"><color theme="0"/></stop>
<stop position="1"><color theme="4"/></stop>
</gradientFill>'
wb <- wb_add_fill(wb, "S2", dims = "A7:K10", gradient_fill = gradient_fill2)
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_font}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_add_numfmt}()},
\code{\link{wb_cell_style}}
}
\concept{styles}
