% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderly.R
\name{orderly_list_src}
\alias{orderly_list_src}
\title{List source reports}
\usage{
orderly_list_src(root = NULL)
}
\arguments{
\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function \strong{does} require that the directory is
configured for orderly, and not just outpack (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
A character vector of names of source reports, suitable
for passing to \code{\link[=orderly_run]{orderly_run()}}
}
\description{
List source reports - that is, directories within \verb{src/} that
look suitable for running with orderly; these will be directories
that contain an entrypoint file - a \code{.R} file with the same name
as the directory (e.g., \code{src/data/data.R} corresponds to \code{data}).
}
\examples{
path <- orderly_example()
orderly_list_src(root = path)
}
\seealso{
\code{\link[=orderly_metadata_extract]{orderly_metadata_extract()}} for listing packets
that have completed
}
