% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{orderly_location_remove}
\alias{orderly_location_remove}
\title{Remove a location}
\usage{
orderly_location_remove(name, root = NULL)
}
\arguments{
\item{name}{The short name of the location.
Cannot remove \code{local} or \code{orphan}}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Nothing
}
\description{
Remove an existing location. Any packets from this location and
not known elsewhere will now be associated with the 'orphan'
location instead.
}
\examples{
# Two roots, one local and one representing some remote orderly location:
local <- orderly_example()
remote <- orderly_example()
orderly_location_add_path("remote", remote, root = local)

orderly_location_list(root = local)

# Remove the remote location:
orderly_location_remove("remote", root = local)
orderly_location_list(root = local)
}
