% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_uninstall.R
\name{osrm_uninstall}
\alias{osrm_uninstall}
\title{Uninstall OSRM Backend Binaries}
\usage{
osrm_uninstall(
  dest_dir = NULL,
  clear_path = TRUE,
  quiet = FALSE,
  all = FALSE,
  force = FALSE
)
}
\arguments{
\item{dest_dir}{A string specifying the directory from which to remove OSRM binaries.
If \code{NULL} (the default), the function looks for an installation in the
per-version subdirectories inside \code{tools::R_user_dir("osrm.backend", which = "cache")}
and removes it. When multiple versions are installed, interactive sessions
that are not \code{quiet} will be prompted (with a numbered menu and \code{0} to cancel)
to choose a directory; otherwise, \code{dest_dir} must be supplied. Ignored if \code{all = TRUE}.}

\item{clear_path}{A logical value. If \code{TRUE} (default), also removes the
\code{PATH} configuration from the project's \code{.Rprofile} by calling \code{osrm_clear_path()}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses informational messages
and confirmation prompts. Defaults to \code{FALSE}.}

\item{all}{A logical value. If \code{TRUE}, removes all OSRM installations found
in the default cache directory. Will prompt for confirmation unless \code{force = TRUE}.
Defaults to \code{FALSE}. When \code{TRUE}, the \code{dest_dir} parameter is ignored.}

\item{force}{A logical value. If \code{TRUE}, skips all confirmation prompts,
enabling non-interactive usage. Defaults to \code{FALSE}.}
}
\value{
\code{TRUE} if one or more directories were successfully removed,
and \code{FALSE} otherwise.
}
\description{
Removes the OSRM backend binaries and optionally clears the \code{PATH}
configuration from the project's \code{.Rprofile}.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  # Install OSRM temporarily
  install_dir <- osrm_install(path_action = "session", quiet = TRUE)

  # Uninstall that specific version and clear PATH changes
  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )

  # If multiple installs exist, remove them all
  osrm_uninstall(all = TRUE, force = TRUE, quiet = TRUE)
}
}
}
