% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eilers_peeters.R
\name{eilers_peeters_modified}
\alias{eilers_peeters_modified}
\title{Eilers & Peeters Model Modification}
\usage{
eilers_peeters_modified(model_result)
}
\arguments{
\item{model_result}{A list containing the results of the model, including parameters such as \code{a}, \code{b}, \code{c}, \code{s}, \code{pm}, \code{ik}, \code{im}, and \code{w}.}
}
\value{
A modified model result as a list with the following elements:
\itemize{
  \item \code{etr_type}: ETR Type based on the model result.
  \item \code{etr_regression_data}: Regression data with ETR predictions based on the fitted model.
  \item \code{sdiff}: The difference between observed and predicted ETR values.
  \item \code{a}: The obtained parameter \code{a}.
  \item \code{b}: The obtained parameter \code{b}.
  \item \code{c}: The obtained parameter \code{c}.
  \item \code{d}: Not available, set to \code{NA_real_}.
  \item \code{alpha}: The initial slope of the light curve, transferred unchanged as \code{s}.
  \item \code{beta}: Not available, set to \code{NA_real_}.
  \item \code{etrmax_with_photoinhibition}: The maximum electron transport rate with photoinhibition, transferred as \code{pm}.
  \item \code{etrmax_without_photoinhibition}: Not available, set to \code{NA_real_}.
  \item \code{ik_with_photoinhibition}: PAR where the transition point from light limitation to light saturation is achieved with photoinhibition, transferred as \code{ik}.
  \item \code{ik_without_photoinhibition}: Not available, set to \code{NA_real_}.
  \item \code{im_with_photoinhibition}: The PAR at which the maximum electron transport rate is achieved with photoinhibition, transferred as \code{im}.
  \item \code{w}: The sharpness of the peak, transferred as \code{w}.
  \item \code{ib}: Not available, set to \code{NA_real_}.
  \item \code{etrmax_with_without_ratio}: Not available, set to \code{NA_real_}.
}
}
\description{
This function enhances the Eilers and Peeters (1988) model by adding parameters not originally included in the model, which were introduced by other models. It also renames parameters to a standardized naming convention used across all models.
}
\details{
A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#eilers_peeters_modified}
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "20240925.csv")
data <- read_dual_pam_data(path)

result <- eilers_peeters_generate_regression_ETR_II(data)
modified_result <- eilers_peeters_modified(result)

}
