% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{.model_param_name_key}
\alias{.model_param_name_key}
\title{Translate names of model tuning parameters}
\usage{
.model_param_name_key(object, as_tibble = TRUE)
}
\arguments{
\item{object}{A workflow or parsnip model specification.}

\item{as_tibble}{A logical. Should the results be in a tibble (the default)
or in a list that can facilitate renaming grid objects?}
}
\value{
A tibble with columns \code{user}, \code{parsnip}, and \code{engine}, or a list
with named character vectors \code{user_to_parsnip} and \code{parsnip_to_engine}.
}
\description{
This function creates a key that connects the identifiers users make for
tuning parameter names, the standardized parsnip parameter names, and the
argument names to the underlying fit function for the engine.
}
\examples{
\dontshow{if (!parsnip:::is_cran_check() & rlang::is_installed("dials")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mod <-
 linear_reg(penalty = tune("regularization"), mixture = tune()) |>
 set_engine("glmnet")

mod |> .model_param_name_key()

rn <- mod |> .model_param_name_key(as_tibble = FALSE)
rn

grid <- tidyr::crossing(regularization = c(0, 1), mixture = (0:3) / 3)

grid |>
  dplyr::rename(!!!rn$user_to_parsnip)

grid |>
  dplyr::rename(!!!rn$user_to_parsnip) |>
  dplyr::rename(!!!rn$parsnip_to_engine)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
