% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{pathling_encode_bundle}
\alias{pathling_encode_bundle}
\title{Encode FHIR Bundles to a dataframe}
\usage{
pathling_encode_bundle(pc, df, resource_name, input_type = NULL, column = NULL)
}
\arguments{
\item{pc}{A Pathling context object.}

\item{df}{A Spark DataFrame containing the bundles with the resources to encode.}

\item{resource_name}{The name of the FHIR resource to extract (Condition, Observation, etc.).}

\item{input_type}{The MIME type of the input string encoding. Defaults to 'application/fhir+json'.}

\item{column}{The column in which the resources to encode are stored. If 'NULL', then the
input DataFrame is assumed to have one column of type string.}
}
\value{
A Spark DataFrame containing the given type of resources encoded into Spark columns.
}
\description{
Takes a dataframe with string representations of FHIR bundles in the given column and outputs
a dataframe of encoded resources.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) withAutoprint(\{ # examplesIf}
pc <- pathling_connect()
json_resources_df <- pathling_spark(pc) \%>\% 
     sparklyr::spark_read_text(path=system.file('extdata','bundle-xml', package='pathling'), 
         whole = TRUE)
pc \%>\% pathling_encode_bundle(json_resources_df, 'Condition',
     input_type = MimeType$FHIR_XML, column = 'contents')
pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
Other encoding functions: 
\code{\link{pathling_encode}()}
}
\concept{encoding functions}
