% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubleLogistics_R.R
\name{Logistic}
\alias{Logistic}
\alias{doubleLog.Zhang}
\alias{doubleLog.AG}
\alias{doubleLog.AG2}
\alias{doubleLog.Beck}
\alias{doubleLog.Elmore}
\alias{doubleLog.Gu}
\alias{doubleLog.Klos}
\title{Fine fitting functions}
\usage{
Logistic(par, t)

doubleLog.Zhang(par, t)

doubleLog.AG(par, t)

doubleLog.AG2(par, t)

doubleLog.Beck(par, t)

doubleLog.Elmore(par, t)

doubleLog.Gu(par, t)

doubleLog.Klos(par, t)
}
\arguments{
\item{par}{A vector of parameters}

\item{t}{A \code{Date} or numeric vector}
}
\description{
double logistics, piecewise logistics and many other functions to
curve fit VI time-series.
}
\details{
\itemize{
\item \code{Logistic} The traditional simplest logistic function. It can
be only used in half growing season, i.e. vegetation green-up or senescence
period.
\item \code{doubleLog.Zhang} Piecewise logistics, (Zhang Xiaoyang, RSE, 2003).
\item \code{doubleAG} Asymmetric Gaussian.
\item \code{doubleLog.Beck} Beck logistics.
\item \code{doubleLog.Gu} Gu logistics.
\item \code{doubleLog.Elmore} Elmore logistics.
\item \code{doubleLog.Klos} Klos logistics.
}

All of those function have \code{par} and \code{formula} attributes for the
convenience for analytical D1 and D2
}
\examples{
# simulate vegetation time-series
t    <- seq(1, 365, 8)
par  <- c(mn = 0.1, mx = 0.7, sos = 50, rsp = 0.1, eos = 250, rau = 0.1)
y    <- doubleLog.Beck(par, t)
data <- data.frame(t, y)
# methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang")
tout <- seq(1, 365, 1)
r <- FitDL.Elmore(y, t, tout)

plot(r, data)
get_GOF(r, data)
get_param(r)
}
\references{
\enumerate{
\item Beck, P.S.A., Atzberger, C., Hogda, K.A., Johansen, B., Skidmore, A.K.,
2006. Improved monitoring of vegetation dynamics at very high latitudes:
A new method using MODIS NDVI. Remote Sens. Environ.
https://doi.org/10.1016/j.rse.2005.10.021.
\item Elmore, A.J., Guinn, S.M., Minsley, B.J., Richardson, A.D., 2012.
Landscape controls on the timing of spring, autumn, and growing season
length in mid-Atlantic forests. Glob. Chang. Biol. 18, 656-674.
https://doi.org/10.1111/j.1365-2486.2011.02521.x. \cr
\item Gu, L., Post, W.M., Baldocchi, D.D., Black, TRUE.A., Suyker, A.E., Verma,
S.B., Vesala, TRUE., Wofsy, S.C., 2009. Characterizing the Seasonal Dynamics
of Plant Community Photosynthesis Across a Range of Vegetation Types,
in: Noormets, A. (Ed.), Phenology of Ecosystem Processes: Applications
in Global Change Research. Springer New York, New York, NY, pp. 35-58.
https://doi.org/10.1007/978-1-4419-0026-5_2. \cr
\item Peter M. Atkinson, et al., 2012, RSE, 123:400-417
\item https://github.com/cran/phenopix/blob/master/R/FitDoubleLogGu.R
}
}
