% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine-main.R
\name{brms_inla_power}
\alias{brms_inla_power}
\title{Core Bayesian Assurance / Power Simulation (Modern, Multi-Effect Ready)}
\usage{
brms_inla_power(
  formula,
  family = gaussian(),
  family_control = NULL,
  Ntrials = NULL,
  E = NULL,
  scale = NULL,
  priors = NULL,
  data_generator = NULL,
  effect_name,
  effect_grid = 0.5,
  sample_sizes = c(50, 100, 200, 400),
  nsims = 200,
  power_threshold = 0.8,
  precision_target = NULL,
  prob_threshold = 0.95,
  effect_threshold = 0,
  credible_level = 0.95,
  rope_bounds = NULL,
  error_sd = 1,
  group_sd = 0.5,
  obs_per_group = 10,
  predictor_means = NULL,
  predictor_sds = NULL,
  seed = 123,
  inla_hyper = NULL,
  compute_bayes_factor = FALSE,
  inla_num_threads = NULL,
  progress = c("auto", "text", "none"),
  family_args = list()
)
}
\arguments{
\item{formula}{Model formula.}

\item{family}{brms GLM family (e.g., gaussian(), binomial()).}

\item{family_control}{Optional list for INLA's control.family.}

\item{Ntrials}{Optional vector for binomial trials.}

\item{E}{Optional vector for Poisson exposure.}

\item{scale}{Optional vector scale parameter for INLA families.}

\item{priors}{Optional brms::prior specification.}

\item{data_generator}{Optional function(n, effect) returning a dataset.}

\item{effect_name}{Character vector of fixed effect names.}

\item{effect_grid}{Vector/data.frame of effect values (supports multi-effect).
For single effects, use a numeric vector. For multiple effects, use a
data.frame with column names matching effect_name.}

\item{sample_sizes}{Vector of sample sizes.}

\item{nsims}{Number of simulations per cell.}

\item{power_threshold}{Decision probability threshold for summary.}

\item{precision_target}{Optional credible interval width target.}

\item{prob_threshold}{Posterior probability threshold for decision rules.}

\item{effect_threshold}{Effect-size threshold.}

\item{credible_level}{Credible interval level (default 0.95).}

\item{rope_bounds}{Optional Region of Practical Equivalence bounds (length 2 vector).}

\item{error_sd}{Gaussian residual standard deviation.}

\item{group_sd}{Random effects standard deviation.}

\item{obs_per_group}{Observations per group.}

\item{predictor_means}{Optional named list of predictor means.}

\item{predictor_sds}{Optional named list of predictor standard deviations.}

\item{seed}{Random seed.}

\item{inla_hyper}{Optional INLA-specific hyperparameters.}

\item{compute_bayes_factor}{Logical, compute Bayes Factor if TRUE.}

\item{inla_num_threads}{Character string specifying INLA threading (e.g., "4:1"
for 4 threads). If NULL (default), automatically detects optimal setting:
"4:1" for 4+ cores, "2:1" for 2-3 cores, "1:1" otherwise.}

\item{progress}{One of "auto", "text", or "none" for progress display.}

\item{family_args}{List of arguments for family-specific data generators.}
}
\value{
List with results, summary, and settings.
}
\description{
Provides Bayesian power analysis and assurance calculation using INLA
(Integrated Nested Laplace Approximation) for efficient computation.
Implements simulation-based power analysis for generalized linear mixed
models with automatic threading optimization.
}
\examples{
\donttest{
# Basic usage with automatic INLA threading
results <- brms_inla_power(
  formula = outcome ~ treatment,
  effect_name = "treatment",
  effect_grid = c(0.2, 0.5, 0.8),
  sample_sizes = c(50, 100, 200),
  nsims = 3
)
print(results$summary)

# Manual INLA threading control
results <- brms_inla_power(
  formula = outcome ~ treatment,
  effect_name = "treatment",
  effect_grid = c(0.2, 0.5, 0.8),
  sample_sizes = c(50, 100, 200),
  inla_num_threads = "8:1",  # Use 8 threads for faster computation
  nsims = 3
)

# Multi-effect design with threading
effect_grid <- expand.grid(
  treatment = c(0, 0.3, 0.6),
  age_effect = c(0, 0.2)
)
results <- brms_inla_power(
  formula = outcome ~ treatment + age_effect,
  effect_name = c("treatment", "age_effect"),
  effect_grid = effect_grid,
  sample_sizes = c(100, 200, 400),
  nsims = 3
)
print(results$summary)
}
# Quick parameter check (runs instantly)
formals(brms_inla_power)
}
