% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelProteins.R
\name{pre_process}
\alias{pre_process}
\title{Pre-process protein intensity data for modeling}
\usage{
pre_process(
  fit_df,
  norm_df,
  sig = "adjP",
  sig_cutoff = 0.05,
  fc = 1,
  n_top = 20,
  find_highcorr = TRUE,
  corr_cutoff = 0.9,
  save_corrmatrix = FALSE,
  file_path = NULL,
  rem_highcorr = TRUE
)
}
\arguments{
\item{fit_df}{A \code{fit_df} object from performing \code{find_dep}.}

\item{norm_df}{The \code{norm_df} object from which the \code{fit_df} object
was obtained.}

\item{sig}{Criteria to denote significance in differential expression.
Choices are \code{"adjP"} (default) for adjusted p-value or \code{"P"}
for p-value.}

\item{sig_cutoff}{Cutoff value for p-values and adjusted p-values in
differential expression. Default is \code{0.05}.}

\item{fc}{Minimum absolute log-fold change to use as threshold for
differential expression. Default is \code{1}.}

\item{n_top}{The number of top hits from \code{find_dep} to be used in
modeling. Default is \code{20}.}

\item{find_highcorr}{Logical. If \code{TRUE} (default), finds highly
correlated proteins.}

\item{corr_cutoff}{A numeric value specifying the correlation cutoff.
Default is \code{0.90}.}

\item{save_corrmatrix}{Logical. If \code{TRUE}, saves a copy of the
protein correlation matrix in a tab-delimited text file labeled
"Protein_correlation.txt" in the directory specified by \code{file_path}.}

\item{file_path}{A string containing the directory path to save the file.}

\item{rem_highcorr}{Logical. If \code{TRUE} (default), removes highly
correlated proteins (predictors or features).}
}
\value{
A \code{model_df} object, which is a data frame of protein
intensities with proteins indicated by columns.
}
\description{
This function pre-processes protein intensity data from
the top differentially expressed proteins identified with \code{find_dep} for
modeling.
}
\details{
This function creates a data frame that contains protein intensities
for a user-specified number of top differentially expressed proteins.
\itemize{\item Using \code{find_highcorr = TRUE}, highly correlated
proteins can be identified, and can be removed with
\code{rem_highcorr = TRUE}.
\item Note: Most models will benefit from reducing correlation between
proteins (predictors or features), therefore we recommend removing those
proteins at this stage to reduce pairwise-correlation.
\item If no or few proteins meet the significance threshold for differential
expression, you may adjust \code{sig}, \code{fc}, and/or \code{sig_cutoff}
accordingly to obtain more proteins for modeling.}
}
\examples{

## Create a model_df object with default settings.
covid_model_df1 <- pre_process(fit_df = covid_fit_df, norm_df = covid_norm_df)

## Change the correlation cutoff.
covid_model_df2 <- pre_process(covid_fit_df, covid_norm_df, corr_cutoff = 0.95)

## Change the significance criteria to include more proteins
covid_model_df3 <- pre_process(covid_fit_df, covid_norm_df, sig = "P")

## Change the number of top differentially expressed proteins to include
covid_model_df4 <- pre_process(covid_fit_df, covid_norm_df, sig = "P", n_top = 24)

}
\seealso{
\itemize{
\item \code{find_dep}, \code{normalize_data}
\item \code{\link[caret:findCorrelation]{caret: findCorrelation}}}
}
\author{
Chathurani Ranathunge
}
