% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{selfesteem2_long}
\alias{selfesteem2_long}
\title{Self Esteem Score Data for Two-way Repeated Measures ANOVA: Long format}
\format{
A data frame with 72 rows and 4 columns.
\describe{
\item{id}{Unique ID of the person}
\item{treatment}{Binary variable indicating the treatment condition: \code{Diet} or \code{ctr}.}
\item{time}{A categorical variable indicating the time of measurement: beginning (\code{t1}), midway (\code{t2}) and at the end (\code{t3}) }
\item{score}{Self-esteem score}
}
}
\usage{
data("selfesteem2_long")
}
\description{
Data are the self esteem score of 12 individuals enrolled in 2
successive short-term trials (4 weeks) - control (placebo) and special diet
trials.

The self esteem score was recorded at three time points: at the beginning
(t1), midway (t2) and at the end (t3) of the trials.

The same 12 participants are enrolled in the two different trials with
enough time between trials.

Two-way repeated measures ANOVA can be performed in order to determine
whether there is interaction between time and treatment on the self
esteem score.

This data set was converted from the \code{selfesteem2} data taken from the
\href{https://cran.r-project.org/package=datarium}{\code{datarium} R
package}.
}
\examples{
data(selfesteem2_long)
selfesteem2_long
}
\keyword{datasets}
