% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piper.R
\name{generateSplits}
\alias{generateSplits}
\title{A balanced split-half generator}
\usage{
generateSplits(data, subsetvars, stratvars = NULL, splits, verbose = TRUE)
}
\arguments{
\item{data}{A dataset to generate split-halves from.}

\item{subsetvars}{Variables identifying subgroups that must be individually split 
into equally sized halves, e.g. participant number and experimental condition.}

\item{stratvars}{Variables identifying subgroups that are nested within the subsetvars, 
and must be split as fairly as possible, while preserving the equal size of 
the two halves of each subset identified by the subsetvars, e.g. stimulus ID.}

\item{splits}{How many splits to generate.}

\item{verbose}{Display progress bar?}
}
\value{
A logical \code{matrix} in which each row represents a row of the input dataset,
and each column represents a single split.
}
\description{
Generates split-half indices that can be stratified by multiple subgroup variables
while guaranteeing near-equal numbers of trials in both halves.
}
\examples{
data(foodAAT)
mysplits<-generateSplits(data=foodAAT,
                         subsetvars=c("subjectid","is_pull","is_target"),
                         stratvars="stimid",
                         splits=1)
half1<-foodAAT[ mysplits[,1],]
half2<-foodAAT[!mysplits[,1],]

}
