% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\name{locate_blocks}
\alias{locate_blocks}
\title{Locate the coordinates of blocks in a chunk}
\usage{
locate_blocks(blocks, pattern, negate = FALSE)
}
\arguments{
\item{blocks}{A character array containing block data.}

\item{pattern}{The pattern to look for. Passed to \link[base:grep]{base::grep}.}

\item{negate}{If \code{TRUE}, return non-matching elements.}
}
\description{
Locate the coordinates of blocks in a chunk
}
\examples{
dbpath <- rbedrock_example_world("example1.mcworld")
db <- bedrockdb(dbpath)
blocks <- get_blocks_value(db, x=37, z=10, dimension=0)
locate_blocks(blocks, "ore")
close(db)

}
