% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocs.R
\name{ocs_shares_extended}
\alias{ocs_shares_extended}
\alias{ocs_child_shares}
\alias{ocs_shares}
\title{Returns information for shares}
\usage{
ocs_shares_extended(
  req,
  path = "",
  as_df = TRUE,
  columns = NULL,
  subfiles = TRUE,
  reshares = FALSE
)

ocs_child_shares(
  req,
  path = "",
  as_df = TRUE,
  columns = c("share_type", "item_type", "permissions", "label", "uid_owner",
    "share_with_displayname")
)

ocs_shares(
  req,
  path = "/",
  as_df = TRUE,
  columns = c("share_type", "item_type", "permissions", "label", "uid_owner",
    "share_with_displayname")
)
}
\arguments{
\item{req}{WebDAV request as returned by \code{\link{wd_connect}}}

\item{path}{folder or file path}

\item{as_df}{if TRUE (default) a data.frame is returned, else a list of IDs}

\item{columns}{column names that should be included into the result
(default \code{NULL} includes all)}

\item{subfiles}{list shares of subfolders}

\item{reshares}{include shares from others}
}
\value{
data.frame or named vector of IDs
}
\description{
\code{ocs_shares_extended} returns extended information for shares.
\code{ocs_shares} returns the shares of a file or folder,
\code{ocs_child_shares} the shares of the files
and subfolders of the given path.
}
\examples{
\dontrun{
r <- wd_connect("https://example.com/remote.php/dav/files/johndoe")
ocs_shares_extended(r, "myfolder/shares")
ocs_shares(r, "myfolder/shares")
ocs_child_shares(r, "myfolder")
}
}
