% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_regmedint_class_constructor.R
\name{new_regmedint}
\alias{new_regmedint}
\title{Low level constructor for a regmedint S3 class object.}
\usage{
new_regmedint(
  data,
  yvar,
  avar,
  mvar,
  cvar,
  emm_ac_mreg,
  emm_ac_yreg,
  emm_mc_yreg,
  eventvar,
  a0,
  a1,
  m_cde,
  c_cond,
  yreg,
  mreg,
  interaction,
  casecontrol
)
}
\arguments{
\item{data}{Data frame containing the following relevant variables.}

\item{yvar}{A character vector of length 1. Outcome variable name. It should be the time variable for the survival outcome.}

\item{avar}{A character vector of length 1. Treatment variable name.}

\item{mvar}{A character vector of length 1. Mediator variable name.}

\item{cvar}{A character vector of length > 0. Covariate names. Use \code{NULL} if there is no covariate. However, this is a highly suspicious situation. Even if \code{avar} is randomized, \code{mvar} is not. Thus, there are usually some confounder(s) to account for the common cause structure (confounding) between \code{mvar} and \code{yvar}.}

\item{emm_ac_mreg}{A character vector of length > 0. Effect modifiers names. The covariate vector in treatment-covariate product term in the mediator model.}

\item{emm_ac_yreg}{A character vector of length > 0. Effect modifiers names. The covariate vector in treatment-covariate product term in the outcome model.}

\item{emm_mc_yreg}{A character vector of length > 0. Effect modifiers names. The covariate vector in mediator-covariate product term in outcome model.}

\item{eventvar}{An character vector of length 1. Only required for survival outcome regression models. Note that the coding is 1 for event and 0 for censoring, following the R survival package convention.}

\item{a0}{A numeric vector of length 1. The reference level of treatment variable that is considered "untreated" or "unexposed".}

\item{a1}{A numeric vector of length 1.}

\item{m_cde}{A numeric vector of length 1. Mediator level at which controlled direct effect is evaluated at.}

\item{c_cond}{A numeric vector of the same length as \code{cvar}. Covariate levels at which natural direct and indirect effects are evaluated at.}

\item{yreg}{A character vector of length 1. Outcome regression type: \code{"linear"}, \code{"logistic"}, \code{"loglinear"}, \code{"poisson"}, \code{"negbin"}, \code{"survCox"}, \code{"survAFT_exp"}, or \code{"survAFT_weibull"}.}

\item{mreg}{A character vector of length 1. Mediator regression type: \code{"linear"} or \code{"logistic"}.}

\item{interaction}{A logical vector of length 1. The presence of treatment-mediator interaction in the outcome model. Default to TRUE.}

\item{casecontrol}{A logical vector of length 1. Default to FALSE. Whether data comes from a case-control study.}
}
\value{
A regmedint object.
}
\description{
This is not a user function and meant to be executed within the regmedint function after validatingthe arguments.
}
