% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_make.R
\name{rxp_export_artifacts}
\alias{rxp_export_artifacts}
\title{Export Nix store paths to an archive}
\usage{
rxp_export_artifacts(
  archive_file = "_rixpress/pipeline_outputs.nar",
  which_log = NULL,
  project_path = "."
)
}
\arguments{
\item{archive_file}{Character, path to the archive, defaults to
"_rixpress/pipeline-outputs.nar"}

\item{which_log}{Character or NULL, regex pattern to match a specific log file.
If NULL (default), the most recent log file will be used.}

\item{project_path}{Character, defaults to ".".
Path to the root directory of the project.}
}
\value{
Nothing, creates an archive file at the specified location.
}
\description{
Creates a single archive file containing the specified Nix store paths
and their dependencies.
This archive can be transferred to another machine and imported into
its Nix store.
}
\examples{
\dontrun{
  # Export the most recent build to the default location
  rxp_export_artifacts()

  # Export a specific build to a custom location
  rxp_export_artifacts(
    archive_file = "my_archive.nar",
    which_log = "20250510"
  )
}
}
\seealso{
Other archive caching functions: 
\code{\link{rxp_import_artifacts}()}
}
\concept{archive caching functions}
