% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{dplyr_extensions}
\alias{dplyr_extensions}
\alias{filter.tm}
\title{Extending \code{dplyr} for \code{tm} class}
\usage{
\method{filter}{tm}(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{.data}. If multiple expressions are included, they are combined with the
\code{&} operator. Only rows for which all conditions evaluate to \code{TRUE} are
kept.}
}
\value{
An object of the same type as \code{.data}. The output as the following properties:
\itemize{
\item \code{tm} objects are a subset of the input, but appear in the same order
\item Underlying \code{data.frame} columns are not modified
\item Underlying \code{data.frame} object's attributes are preserved
}
}
\description{
The \code{filter()} function extension subsets \code{tm} that satisfy set conditions.
To be retained, the \code{tm} object must produce a value of \code{TRUE} for all conditions.
Note that when a condition evaluates to \code{NA}, the row will be dropped, unlike
base subsetting with \code{[}.
}
\seealso{
\code{\link[dplyr:filter]{dplyr::filter()}} for examples of generic implementation
}
