% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{brauer_2008}
\alias{brauer_2008}
\alias{brauer_2008_tidy}
\alias{brauer_2008_triple}
\title{Brauer 2008}
\format{
A tibble with 18,000 rows and 8 columns:
\describe{
  \item{name}{Common gene name}
  \item{BP}{Gene ontology biological process of the gene}
  \item{MF}{Gene ontology molecular function of the gene}
  \item{sample}{Sample name}
  \item{nutrient}{Which nutrient limits growth (Glucose, Nitrogen,
    Phosphorous, Sulfur, Uracil, Leucine}
  \item{DR}{Dilution rate of the culture - basically how fast the cells
    are growing}
  \item{expression}{Expression level of the gene, log2 observation relative
    to a replicate of G0.3}
}

An object of class \code{tidy_omic} (inherits from \code{tomic}, \code{general}) of length 2.

An object of class \code{triple_omic} (inherits from \code{tomic}, \code{general}) of length 4.
}
\source{
\url{https://pubmed.ncbi.nlm.nih.gov/17959824/}
}
\usage{
brauer_2008

brauer_2008_tidy

brauer_2008_triple
}
\description{
An RNA expression (microarray) dataset looking at how yeast gene expression
  changes as nutrient sources and nutrient richness changes.

\code{\link{brauer_2008}} formatted as a tidy_omic object

\code{\link{brauer_2008}} formatted as a triple_omic object
}
\details{
This version of the dataset contains only 500 genes randomly
  selected from the ~6K genes in the complete dataset.
}
\keyword{datasets}
