% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{cv.rq.group.pen}
\alias{cv.rq.group.pen}
\title{Old cross validation function for group penalty}
\usage{
cv.rq.group.pen(
  x,
  y,
  groups,
  tau = 0.5,
  lambda = NULL,
  penalty = "SCAD",
  intercept = TRUE,
  criteria = "CV",
  cvFunc = "check",
  nfolds = 10,
  foldid = NULL,
  nlambda = 100,
  eps = 1e-04,
  init.lambda = 1,
  alg = "huber",
  penGroups = NULL,
  ...
)
}
\arguments{
\item{x}{Matrix of predictors.}

\item{y}{Vector of responses.}

\item{groups}{Vector of groups.}

\item{tau}{Quantile being modeled.}

\item{lambda}{Vector of lambdas. Default is for lambdas to be automatically generated.}

\item{penalty}{Type of penalty: "LASSO", "SCAD" or "MCP".}

\item{intercept}{Whether model should include an intercept. Constant does not need to be included in "x".}

\item{criteria}{How models will be evaluated. Either cross-validation "CV", BIC "BIC" or large P BIC "PBIC".}

\item{cvFunc}{If cross-validation is used how errors are evaluated. Check function "check", "SqErr" (Squared Error) or "AE" (Absolute Value).}

\item{nfolds}{K for K-folds cross-validation.}

\item{foldid}{Group id for cross-validation. Function will randomly generate groups if not specified.}

\item{nlambda}{Number of lambdas for which models are fit.}

\item{eps}{Multiple of lambda max for Smallest lambda used.}

\item{init.lambda}{Initial lambda used to find the maximum lambda. Not needed if lambda values are set.}

\item{alg}{Algorithm used for fit. Only "LP", "QICD" is no longer available.}

\item{penGroups}{Specify which groups will be penalized. Default is to penalize all groups.}

\item{...}{Additional arguments to be sent to rq.group.fit}
}
\value{
Returns the following: 
\describe{
\item{beta}{ Matrix of coefficients for different values of lambda}
\item{residuals}{ Matrix of residuals for different values of lambda.}
\item{rho}{Vector of rho, unpenalized portion of the objective function, for different values of lambda.}
\item{cv}{ Data frame with "lambda" and second column is the evaluation based on the criteria selected.}
\item{lambda.min}{ Lambda which provides the smallest statistic for the selected criteria.}
\item{penalty}{ Penalty selected.} 
\item{intercept}{Whether intercept was included in model.}
\item{groups}{Group structure for penalty function.}
}
}
\description{
This function is no longer exported. Recommend using rq.group.pen.cv() instead.
}
\examples{
\dontrun{
x <- matrix(rnorm(800),nrow=100)
y <- 1 + x[,1] - 3*x[,5] + rnorm(100)
cv_model <- cv.rq.group.pen(x,y,groups=c(rep(1,4),rep(2,4)),criteria="BIC")
}
}
\references{
\itemize{
\item Yuan, M. and Lin, Y. (2006). Model selection and estimation in regression with grouped variables. \emph{J. R. Statist. Soc. B}, \bold{68}, 49-67.
\item Peng, B. and Wang, L. (2015). An Iterative Coordinate Descent Algorithm for High-Dimensional Nonconvex Penalized Quantile Regression. \emph{Journal of Computational and Graphical Statistics}, \bold{24}, 676-694.
}
}
\keyword{internal}
