% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Means_DDCt.r
\name{Means_DDCt}
\alias{Means_DDCt}
\title{\eqn{\Delta \Delta C_T} analysis analysis using a model}
\usage{
Means_DDCt(model, specs, p.adj = "none")
}
\arguments{
\item{model}{an `lmer` fitted model object created by ANOVA_DDCt or REPEATED_DDCt functions}

\item{specs}{A character vector specifying the names of the predictors over which FC values are desired}

\item{p.adj}{Method for adjusting p values}
}
\value{
Table of FC values, significance and confidence interval.
}
\description{
Relative expression (\eqn{\Delta \Delta C_T} method) analysis using a model object produced by the
\code{ANOVA_DDCt} or \code{REPEATED_DDCt}.
}
\details{
The \code{Means_DDCt} function performs fold change (\eqn{\Delta \Delta C_T} method) analysis using a model produced by the
\code{ANOVA_DDCt} or \code{REPEATED_DDCt}. The values can be returned for any effects in the model including simple effects,
interactions and slicing if an ANOVA model is used, but ANCOVA models returned by rtpcr package only include simple effects.
}
\examples{

# Returning fold change values from a fitted model.
# Firstly, result of `ANOVA_DDCt` or `REPEATED_DDCt` is 
# acquired which includes a model object:
res <- ANOVA_DDCt(data_3factor, numberOfrefGenes = 1, mainFactor.column = 1, block = NULL)

# Returning fold change values of Type levels from a fitted model:
Means_DDCt(res$lm_ANOVA, specs = "Type")

# Returning fold change values of Conc levels from a fitted model:
Means_DDCt(res$lm_ANOVA, specs = "Conc")

# Returning fold change values of Conc levels sliced by Type:
Means_DDCt(res$lm_ANOVA, specs = "Conc | Type")

# Returning fold change values of Conc levels sliced by Type*SA:
Means_DDCt(res$lm_ANOVA, specs = "Conc | (Type*SA)")


}
\author{
Ghader Mirzaghaderi
}
