% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA_DDCt.r
\name{ANOVA_DDCt}
\alias{ANOVA_DDCt}
\title{Delta Delta Ct ANOVA analysis}
\usage{
ANOVA_DDCt(
  x,
  numOfFactors,
  numberOfrefGenes,
  mainFactor.column,
  block,
  analysisType = "anova",
  mainFactor.level.order = NULL,
  p.adj = "none",
  plot = FALSE,
  plotType = "RE",
  analyseAllTarget = TRUE
)
}
\arguments{
\item{x}{A data frame containing experimental design columns, target gene
E/Ct column pairs, and reference gene E/Ct column pairs. Reference gene
columns must be located at the end of the data frame.}

\item{numOfFactors}{Integer. Number of experimental factor columns
(excluding \code{rep} and optional \code{block}).}

\item{numberOfrefGenes}{Integer. Number of reference genes. Each reference gene
must be represented by two columns (E and Ct).}

\item{mainFactor.column}{Column index or name of the factor for which relative expression is calculated.
When \code{analysisType = "ancova"}, remaining factors are treated as covariates.}

\item{block}{Character or \code{NULL}. Name of the blocking factor column.
When a qPCR experiment is done in multiple qPCR plates, 
variation resulting from the plates may interfere with the actual amount of 
gene expression. One solution is to conduct each plate as a randomized block 
so that at least one replicate of each treatment and control is present 
on a plate. Block effect is usually considered as random and its interaction 
with any main effect is not considered.}

\item{analysisType}{Character string specifying the analysis type; one of \code{"anova"} (default)
or \code{"ancova"}.}

\item{mainFactor.level.order}{Optional character vector specifying the order of levels for the main factor.
If \code{NULL}, the first observed level is used as the calibrator.
If provided, the first element of the vector is used as the calibrator level.}

\item{p.adj}{Method for p-value adjustment. See \code{\link[stats]{p.adjust}}.}

\item{plot}{Logical; if \code{FALSE}, per gene-plots are not generated.}

\item{plotType}{Plot scale to use: \code{"RE"} for relative expression or
\code{"log2FC"} for log2 fold change.}

\item{analyseAllTarget}{Logical or character.
If \code{TRUE} (default), all target genes are analysed.
Alternatively, a character vector specifying the names (names of their Efficiency columns) of target genes
to be analysed.}
}
\value{
An object containing expression table, lm models, residuals, raw data and ANOVA table for each gene.
\describe{  
\item{\eqn{\Delta \Delta C_T} combined expression table}{\code{object$combinedFoldChange}}
\item{ANOVA table}{\code{object$perGene$gene_name$ANOVA_table}}
\item{lm ANOVA}{\code{object$perGene$gene_name$lm_ANOVA}}
\item{lm ANCOVA}{\code{object$perGene$gene_name$lm_ANCOVA}}
\item{Residuals}{\code{resid(object$perGene$gene_name$lm_ANOVA)}}
\item{log2FC_Plot}{\code{object$perGene$gene_name$log2FC_Plot}}
\item{RE_Plot}{\code{object$perGene$gene_name$RE_Plot}}
}
}
\description{
Apply \eqn{\Delta \Delta C_T} analysis to each target gene
in the input data frame. Target and reference genes must be provided as paired
efficiency (E) and Ct columns located after the experimental design columns.
columns.
}
\details{
\eqn{\Delta \Delta C_T} analysis is performed for 
the \code{mainFactor.column} based on a full model factorial 
experiment by default. However, if \code{ancova}, the \code{analysisType} argument,
analysis of covariance is performed for the levels of the \code{mainFactor.column} and the other factors are 
treated as covariates. if the interaction between the main factor and the covariate is significant, ANCOVA is not appropriate. 
ANCOVA is basically used when a factor is affected by uncontrolled quantitative covariate(s). 
For example, suppose that wDCt of a target gene in a plant is affected by temperature. The gene may 
also be affected by drought. Since we already know that temperature affects the target gene, we are 
interested to know if the gene expression is also altered by the drought levels. We can design an 
experiment to understand the gene behavior at both temperature and drought levels at the same time. 
The drought is another factor (the covariate) that may affect the expression of our gene under the 
levels of the first factor i.e. temperature. The data of such an experiment can be analyzed by ANCOVA 
or using ANOVA based on a factorial experiment. ANCOVA is done  
even there is only one factor (without covariate or factor  variable).
}
\examples{
data1 <- read.csv(system.file("extdata", "data_2factorBlock3ref.csv", package = "rtpcr"))
ANOVA_DDCt(x = data1,
           numOfFactors = 2,
           numberOfrefGenes = 2,
           block = "block",
           mainFactor.column = 2,
           plot = FALSE,
           p.adj = "none")
           
data2 <- read.csv(system.file("extdata", "data_1factor_one_ref.csv", package = "rtpcr"))          
ANOVA_DDCt(
           x = data2,
           numOfFactors = 1,
           numberOfrefGenes = 1,
           block = NULL,
           mainFactor.column = 1,
           plot = FALSE,
           p.adj = "none")
           
}
