% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_&_Write_Data.R
\name{Create_10X_H5}
\alias{Create_10X_H5}
\title{Create H5 from 10X Outputs}
\usage{
Create_10X_H5(
  raw_data_file_path,
  source_type = "10X",
  save_file_path,
  save_name
)
}
\arguments{
\item{raw_data_file_path}{file path to raw data file(s).}

\item{source_type}{type of source data (Default is "10X").  Alternatively can provide "Matrix" or "data.frame".}

\item{save_file_path}{file path to directory to save file.}

\item{save_name}{name prefix for output H5 file.}
}
\value{
A HDF5 format file that will be recognized as 10X Cell Ranger formatted file by Seurat or LIGER.
}
\description{
Creates HDF5 formatted output analogous to the outputs created by Cell Ranger and can be read into
Seurat, LIGER, or SCE class object.  Requires DropletUtils package from Bioconductor.
}
\examples{
\dontrun{
Create_10X_H5(raw_data_file_path = "file_path", save_file_path = "file_path2", save_name = "NAME")
}

}
\concept{read_&_write}
