% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_func.R
\name{ramp}
\alias{ramp}
\title{Create ramp function}
\usage{
ramp(times, start, finish, height = 1)
}
\arguments{
\item{times}{Vector of simulation times}

\item{start}{Start time of ramp}

\item{finish}{End time of ramp}

\item{height}{End height of ramp, defaults to 1}
}
\value{
Ramp interpolation function
}
\description{
Create a ramp function that increases linearly from 0 to a specified height at a specified start time, and stays at this height after the specified end time.
}
\details{
Equivalent of Ramp() in Insight Maker
}
\examples{
# Create a simple model with a ramp function
sfm <- xmile() |>
  build("a", "stock") |>
  # Specify the global variable "times" as simulation times
  build("input", "constant", eqn = "ramp(times, 20, 30, 3)") |>
  build("inflow", "flow", eqn = "input(t)", to = "a")

\dontshow{
sfm <- sim_specs(sfm, save_at = 1, dt = .1)
}

sim <- simulate(sfm, only_stocks = FALSE)
plot(sim)

# To create a decreasing ramp, set the height to a negative value
sfm <- build(sfm, "input", eqn = "ramp(times, 20, 30, -3)")

sim <- simulate(sfm, only_stocks = FALSE)
plot(sim)

}
\seealso{
\code{\link[=step]{step()}}, \code{\link[=pulse]{pulse()}}, \code{\link[=seasonal]{seasonal()}}
}
\concept{input}
