% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R, R/model_ar.R, R/model_arima.R,
%   R/model_glm.R, R/model_lm.R, R/model_mgcv_gam.R, R/model_ranger.R,
%   R/model_workflow.R, R/model_xgboost.R
\name{model_checker}
\alias{model_checker}
\alias{model_checker.default}
\alias{model_checker.ar}
\alias{model_checker.Arima}
\alias{model_checker.forecast_ARIMA}
\alias{model_checker.glm}
\alias{model_checker.lm}
\alias{model_checker.gam}
\alias{model_checker.ranger}
\alias{model_checker.workflow}
\alias{model_checker.xgboost}
\alias{model_checker.xgb.Booster}
\title{Check that the type of model is supported by the native implementation of the model class}
\usage{
model_checker(x)

\method{model_checker}{default}(x)

\method{model_checker}{ar}(x)

\method{model_checker}{Arima}(x)

\method{model_checker}{forecast_ARIMA}(x)

\method{model_checker}{glm}(x)

\method{model_checker}{lm}(x)

\method{model_checker}{gam}(x)

\method{model_checker}{ranger}(x)

\method{model_checker}{workflow}(x)

\method{model_checker}{xgboost}(x)

\method{model_checker}{xgb.Booster}(x)
}
\arguments{
\item{x}{Model object for the model to be explained.}
}
\value{
Error or NULL
}
\description{
The function checks whether the model given by \code{x} is supported.
If \code{x} is not a supported model the function will return an error message, otherwise it return NULL
(meaning all types of models with this class is supported)
}
\seealso{
See \code{\link[=predict_model]{predict_model()}} for more information about what type of models \code{shapr} currently support.
}
\keyword{internal}
