% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_stars.R
\name{sits_as_stars}
\alias{sits_as_stars}
\title{Convert a data cube into a stars object}
\usage{
sits_as_stars(
  cube,
  tile = cube[1L, ]$tile,
  bands = NULL,
  dates = NULL,
  proxy = FALSE
)
}
\arguments{
\item{cube}{A sits cube.}

\item{tile}{Tile of the data cube.}

\item{bands}{Bands of the data cube to be part of \code{stars} object.}

\item{dates}{Dates of the data cube to be part of \code{stars} object.}

\item{proxy}{Produce a stars proxy object.}
}
\value{
An space-time stars object.
}
\description{
Uses the information about files, bands and dates
in a data cube to produce an object of class \code{stars}.
User has to select a tile from the data cube. By default,
all bands and dates are included in the \code{stars} object.
Users can select bands and dates.
}
\note{
By default, the \code{stars} object will be loaded in memory. This
can result in heavy memory usage. To produce a \code{stars.proxy} object,
uses have to select a single date, since \code{stars} does not allow
proxy objects to be created with two dimensions.
}
\examples{
if (sits_run_examples()) {
    # convert sits cube to an sf object (polygon)
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    stars_object <- sits_as_stars(cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara.inpe@gmail.com}
}
