% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addLoggingWrapper.R
\name{addLoggingWrapper}
\alias{addLoggingWrapper}
\title{Return a function which internally stores x or y values.}
\usage{
addLoggingWrapper(fn, logg.x = FALSE, logg.y = TRUE, size = 100L)
}
\arguments{
\item{fn}{[\code{smoof_function}]\cr
Smoof function.}

\item{logg.x}{[\code{logical(1)}]\cr
Should x-values be logged?
Default is \code{FALSE}.}

\item{logg.y}{[\code{logical(1)}]\cr
Should objective values be logged?
Default is \code{TRUE}.}

\item{size}{[\code{integer(1)}]\cr
Initial size of the internal data structures used for logging.
Default is 100. I.e., there is space reserved for 100 function evaluations.
In case of an overflow (i.e., more function evaluations than space reserved)
the data structures are re-initialized by adding space for another \code{size} evaluations.
This comes handy if you know the number of function evaluations (or at least
an upper bound thereof) a-priori and may serve to reduce the time complextity
of logging values.}
}
\value{
[\code{smoof_logging_function}]
}
\description{
Often it is desired and useful to store the optimization path, i.e., the evaluated
function values and/or the parameters. Not all optimization algorithms offer
such a trace. This wrapper makes a smoof function handle x/y-values itself.
}
\note{
Logging values, in particular logging x-values, will substantially slow
down the evaluation of the function.
}
\examples{
# We first build the smoof function and apply the logging wrapper to it
fn = makeSphereFunction(dimensions = 2L)
fn = addLoggingWrapper(fn, logg.x = TRUE)

# We now apply an optimization algorithm to it and the logging wrapper keeps
# track of the evaluated points.
res = optim(fn, par = c(1, 1), method = "Nelder-Mead")

# Extract the logged values
log.res = getLoggedValues(fn)
print(log.res$pars)
print(log.res$obj.vals)
log.res = getLoggedValues(fn, compact = TRUE)
print(log.res)

}
