%  file sn/man/plot.fitdistr.grouped.Rd  
%  This file is a component of the package 'sn' for R
%  copyright (C) 2022 Adelchi Azzalini
%
\name{plot.fitdistr.grouped}
\alias{plot.fitdistr.grouped}
\alias{plot,fitdistr.grouped-method}
\title{Plot an object generated by \code{fitdistr.grouped}}

\description{
The object produced by \code{\link{fitdistr.grouped}} is plotted in the form
of an histogram of the input original observed frequencies with superimposed 
the fitted parametric density function. 
}

\usage{
\S3method{plot}{fitdistr.grouped}(x, freq = FALSE, col = "grey90", 
  border = "grey80",  pdfcol = "blue", main, sub = NULL, xlab, ylab, xlim, ylim, 
  axes = TRUE, labels = FALSE, ...)
}

\arguments{
  \item{x}{a \code{link{fitdistr.grouped}} object.}
  
  \item{freq}{logical;  if \code{TRUE}, the histogram graphic is to present 
    a representation of frequencies; if \code{FALSE} (default value),
    densities are plotted.}
    
  \item{col}{a colour to be used to fill the bars. }
  
  \item{border}{the colour of the border around the bars.}
  
  \item{pdfcol}{the colour of the fitted parametric distribution.}
  
  \item{main, sub, xlab, ylab}{these arguments to \code{title} an be omitted,
    in which case default values are constructed.}

  \item{xlim, ylim}{ the range of \code{x} and \code{y} values with 
    sensible defaults.}

  \item{axes}{logical, indicating if axes should be drawn.}
  
  \item{labels}{logical or character. Additionally draw labels on top of bars, 
    if not FALSE; if TRUE, draw the counts or rounded densities; 
    if labels is a character, draw itself.}
  
  \item{\dots}{further graphical parameters to title and axis.}
}

\details{The function builds on \code{\link[graphics]{plot.histogram}}, 
but some lesser features have been dropped.}

\value{
A list with the following components
 \item{hist}{an object of class \code{histogram} which produces the histogram.}
 \item{x, y}{the values used for plotting the fitted parametric distribution.}
}
% \references{%% ~put references to the literature/web site here ~}

\author{Adelchi Azzalini}

% \note{%%  ~~further notes~~}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{fitdistr.grouped}} for generating a suitable object, 
\code{\link[graphics]{plot.histogram}} for the related more general function.
}
\examples{
data(barolo)
attach(barolo)
A75 <- (reseller=="A" & volume==75)
logPrice <- log(price[A75],10) # as used in selm documentation; see its fitting
detach(barolo)
breaks<- seq(1, 3, by=0.25)
f <- cut(logPrice, breaks = breaks)
freq <- tabulate(f, length(levels(f))) 
logPrice.grouped <- fitdistr.grouped(breaks, freq, family='ST')
plot(logPrice.grouped)
}

\keyword{distribution}
\keyword{hplot}
\concept{grouped data}
