% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRED_predict.R
\name{predict.spBFA}
\alias{predict.spBFA}
\title{predict.spBFA}
\usage{
\method{predict}{spBFA}(
  object,
  NewTimes,
  NewX = NULL,
  NewTrials = NULL,
  type = "temporal",
  Verbose = TRUE,
  seed = 54,
  ...
)
}
\arguments{
\item{object}{A \code{\link{spBFA}} model object for which predictions
are desired from.}

\item{NewTimes}{A numeric vector including desired time(s) points for prediction.}

\item{NewX}{A matrix including covariates at times \code{NewTimes} for prediction. 
\code{NewX} must have dimension \code{(M x O x NNewVistis) x P}. Where \code{NNewVisits} is the number of temporal 
locations being predicted. The default sets \code{NewX} to \code{NULL}, which assumes that the covariates for all predictions 
are the same as the final time point.}

\item{NewTrials}{An array indicating the trials for categorical predictions. The array must have dimension \code{M x C x NNewVisits}
and contain only non-negative integers. The default sets \code{NewTrials} to \code{NULL}, which assumes the trials for all predictions
are the same as the final time point.}

\item{type}{A character string indicating the type of prediction, choices include "temporal" and "spatial". Spatial prediction has not been implemented yet.}

\item{Verbose}{A boolean logical indicating whether progress should be output.}

\item{seed}{An integer value used to set the seed for the random number generator
(default = 54).}

\item{...}{other arguments.}
}
\value{
\code{predict.spBFA} returns a list containing the following objects.

  \describe{

  \item{\code{Eta}}{A \code{list} containing \code{NNewVistis} matrices, one for each new time prediction. Each matrix is dimension \code{NKeep x K}, where
  \code{K} is the number of latent factors Each matrix contains posterior samples obtained by Bayesian krigging.}

  \item{\code{Y}}{A \code{list} containing \code{NNewVistis} posterior predictive distribution
  matrices. Each matrix is dimension \code{NKeep x (M * O)}, where \code{M} is the number of spatial locations and \code{O} the number of observation types.
  Each matrix is obtained through Bayesian krigging.}

  }
}
\description{
Predicts future observations from the \code{\link{spBFA}} model.
}
\details{
\code{predict.spBFA} uses Bayesian krigging to predict vectors at future
 time points. The function returns the krigged factors (\code{Eta}) and also the observed outcomes (\code{Y}).
}
\examples{
###Load pre-computed regression results
data(reg.bfa_sp)

###Compute predictions
pred <- predict(reg.bfa_sp, NewTimes = 3)
pred.observations <- pred$Y$Y10 # observed data predictions
pred.krig <- pred$Eta$Eta10 # krigged parameters

}
\author{
Samuel I. Berchuck
}
