% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HFWM_pred.R
\name{HFWM_pred}
\alias{HFWM_pred}
\title{Prediction Function for Hierarchical Finlay-Wilkinson Model}
\usage{
HFWM_pred(Y, VAR, ENV, VAR2, ENV2, save_int = FALSE, kin_info = FALSE,
  A = NULL, inits = NULL, hyper_para = NULL, M_iter = 5000,
  burn_in = 3000, thin = 5, seed = NULL)
}
\arguments{
\item{Y}{A length-N1 numerical response vector from training set}

\item{VAR}{A length-N1 factor/character vector indicating the genotype information of Y}

\item{ENV}{A length-N1 factor/character vector indicating the field information of Y}

\item{VAR2}{A length-N2 factor/character vector indicating the genotype information of testing set}

\item{ENV2}{A length-N2 factor/character vector indicating the field information of of testing set}

\item{save_int}{A logical parameter controling whether to save prediction credible intervals}

\item{kin_info}{A logical parameter controling if to use kinship matrix}

\item{A}{kinship matrix, give value only if kin_info = TRUE}

\item{inits}{initial values, default is given}

\item{hyper_para}{hyper-parameter values, default is given}

\item{M_iter}{Total iteration number}

\item{burn_in}{Burn in number}

\item{thin}{Thinning value}

\item{seed}{Random seed value}
}
\value{
Mean prediction values and/or prediction intervals
}
\description{
This function ignores spatial effects.
}
\examples{
library(spFW)

# load and split data
data(spFW_example_data)
idx_pred <- sample(125, 25)

Y0 <- spFW_example_data$yield
VAR0 <- spFW_example_data$geno
ENV0 <- spFW_example_data$loc


Y1 <- Y0[-idx_pred]
Y2 <- Y0[idx_pred]
VAR1 <- VAR0[-idx_pred]
VAR2 <- VAR0[idx_pred]
ENV1 <- ENV0[-idx_pred]
ENV2 <- ENV0[idx_pred]
order_y <- order(Y2)

# run model
pred0 <- HFWM_pred(Y1, VAR1, ENV1, VAR2, ENV2, save_int = TRUE,
                   M_iter = 1000, burn_in = 500, thin = 5)

# visualize prediction results
plot(1:25, pred0$PY[order_y], ylim = c(50, 250), pch = 15, col = "red",
     xlab = "Plant ID for Prediction", ylab = "Yield",
     main = "95\% Prediction Intervals with Predicted Mean (Red) Versus True Yield (Blue)")
points(1:25, Y2[order_y], col = "blue")
for (i in 1:25){
  lines(x = c(i,i), y = c(pred0$PY_CI[,order_y][1,i], pred0$PY_CI[,order_y][4,i]))
}



}
