% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abfit.R
\name{abfit_reg_opts}
\alias{abfit_reg_opts}
\title{Return a list of options for an ABfit analysis with regularision.}
\usage{
abfit_reg_opts(
  init_damping = 5,
  maxiters = 128,
  max_shift_pre = 0.078,
  max_shift_fine = 0.05,
  max_damping = 15,
  max_phase = 360,
  lambda = NULL,
  ppm_left = 4,
  ppm_right = 0.2,
  zp = TRUE,
  bl_ed_pppm = 2,
  auto_bl_flex = TRUE,
  bl_comps_pppm = 15,
  adaptive_bl_comps_pppm = TRUE,
  export_sp_fit = FALSE,
  max_asym = Inf,
  max_basis_shift = Inf,
  max_basis_damping = Inf,
  maxiters_pre = 1000,
  algo_pre = "NLOPT_LN_NELDERMEAD",
  min_bl_ed_pppm = NULL,
  max_bl_ed_pppm = 7,
  auto_bl_flex_n = 20,
  pre_fit_bl_ed_pppm = 1,
  remove_lip_mm_prefit = FALSE,
  pre_align = TRUE,
  max_pre_align_shift = 0.1,
  pre_align_ref_freqs = c(2.01, 3.03, 3.22),
  noise_region = c(-0.5, -2.5),
  optimal_smooth_criterion = "maic",
  aic_smoothing_factor = 5,
  anal_jac = TRUE,
  pre_fit_ppm_left = 4,
  pre_fit_ppm_right = 1.8,
  phi1_optim = FALSE,
  phi1_init = 0,
  max_dphi1 = 0.2,
  max_basis_shift_broad = NULL,
  max_basis_damping_broad = NULL,
  ahat_calc_method = "lh_pnnls",
  prefit_phase_search = TRUE,
  freq_reg = 0.004,
  freq_reg_naa = NULL,
  lb_reg = "lcm_compat",
  asym_reg = 0.1,
  output_all_paras = FALSE,
  output_all_paras_raw = FALSE,
  input_paras_raw = NULL,
  optim_lw_only = FALSE,
  optim_lw_only_limit = 20,
  lb_init = "lcm_compat",
  lb_init_approx_fit = FALSE,
  zf_offset = NULL
)
}
\arguments{
\item{init_damping}{initial value of the Gaussian global damping parameter
(Hz). Very poorly shimmed or high field data may benefit from a larger value.}

\item{maxiters}{The maximum number of iterations to run for the detailed fit.}

\item{max_shift_pre}{The maximum allowable global shift to be applied in the
approximate (pre-fit) phases of analysis (ppm).}

\item{max_shift_fine}{The maximum allowable global shift to be applied in the
detailed fit phase of analysis (ppm).}

\item{max_damping}{maximum permitted value of the global damping parameter
(Hz).}

\item{max_phase}{the maximum absolute permitted value of the global
zero-order phase term (degrees). Note, the prefit_phase_search option is not
constrained by this term.}

\item{lambda}{manually set the the baseline smoothness parameter.}

\item{ppm_left}{downfield frequency limit for the fitting range (ppm).}

\item{ppm_right}{upfield frequency limit for the fitting range (ppm).}

\item{zp}{zero pad the data to twice the original length before fitting.}

\item{bl_ed_pppm}{manually set the the baseline smoothness parameter (ED per
ppm).}

\item{auto_bl_flex}{automatically determine the level of baseline smoothness.}

\item{bl_comps_pppm}{spline basis density (signals per ppm).}

\item{adaptive_bl_comps_pppm}{adjust the spline basis density in the detailed
fit phase, based on the required level of smoothness, to reduce computation
time.}

\item{export_sp_fit}{add the fitted spline functions to the fit result.}

\item{max_asym}{maximum allowable value of the asymmetry parameter.}

\item{max_basis_shift}{maximum allowable frequency shift for individual basis
signals (ppm).}

\item{max_basis_damping}{maximum allowable Lorentzian damping factor for
individual basis signals (Hz).}

\item{maxiters_pre}{maximum iterations for the coarse (pre-)fit.}

\item{algo_pre}{optimisation method for the coarse (pre-)fit.}

\item{min_bl_ed_pppm}{minimum value for the candidate baseline flexibility
analyses (ED per ppm).}

\item{max_bl_ed_pppm}{minimum value for the candidate baseline flexibility
analyses (ED per ppm).}

\item{auto_bl_flex_n}{number of candidate baseline analyses to perform.}

\item{pre_fit_bl_ed_pppm}{level of baseline flexibility to use in the coarse
fitting stage of the algorithm (ED per ppm).}

\item{remove_lip_mm_prefit}{remove broad signals in the coarse fitting stage
of the algorithm.}

\item{pre_align}{perform a pre-alignment step before coarse fitting.}

\item{max_pre_align_shift}{maximum allowable shift in the pre-alignment step
(ppm).}

\item{pre_align_ref_freqs}{a vector of prominent spectral frequencies used in
the pre-alignment step (ppm).}

\item{noise_region}{spectral region to estimate the noise level (ppm).}

\item{optimal_smooth_criterion}{method to determine the optimal smoothness.}

\item{aic_smoothing_factor}{modification factor for the AIC calculation.
Larger values result in less flexible baselines.}

\item{anal_jac}{use a analytical approximation to the jacobian in the
detailed fitting stage.}

\item{pre_fit_ppm_left}{downfield frequency limit for the fitting range in
the coarse fitting stage of the algorithm (ppm).}

\item{pre_fit_ppm_right}{upfield frequency limit for the fitting range in the
coarse fitting stage of the algorithm (ppm).}

\item{phi1_optim}{apply and optimise a frequency dependant phase term.}

\item{phi1_init}{initial value for the frequency dependant phase term (ms).}

\item{max_dphi1}{maximum allowable change from the initial frequency
dependant phase term (ms).}

\item{max_basis_shift_broad}{maximum allowable shift for broad signals in the
basis (ppm). Determined based on their name beginning with Lip or MM. The
default value is set to max_basis_shift.}

\item{max_basis_damping_broad}{maximum allowable Lorentzian damping for broad
signals in the basis (Hz). Determined based on their name beginning with Lip
or MM. The default value is set to max_basis_damping.}

\item{ahat_calc_method}{method to calculate the metabolite amplitudes. May be
one of: "lh_pnnls" or "ls".}

\item{prefit_phase_search}{perform a 1D search for the optimal phase in the
prefit stage of the algorithm.}

\item{freq_reg}{frequency shift parameter.}

\item{freq_reg_naa}{frequency shift parameter for NAA and NAAG.}

\item{lb_reg}{individual line broadening parameter.}

\item{asym_reg}{lineshape asymmetry parameter.}

\item{output_all_paras}{include more fitting parameters in the fit table,
e.g. individual shift and damping factors for each basis set element.}

\item{output_all_paras_raw}{include raw fitting parameters in the fit table.
For advanced diagnostic use only.}

\item{input_paras_raw}{input raw fitting parameters. For advanced diagnostic
use only.}

\item{optim_lw_only}{optimize the global line-broadening term only.}

\item{optim_lw_only_limit}{limits for the line-breading term as a percentage
of the starting value when optim_lw_only is TRUE.}

\item{lb_init}{initial Lorentzian line broadening value (in Hz) for the
individual basis signals. Setting to 0 will clash with the minimum allowable
value (eg hard constraint) during the detailed fit.}

\item{lb_init_approx_fit}{apply lb_init to the basis during the approximate
iterative fit.}

\item{zf_offset}{offset in number of data points from the end of the FID to
zero-fill. Default is NULL and will automatically set this to 50 points when
the FID distortion flag is set for the mrs_data.}
}
\value{
full list of options.
}
\description{
Return a list of options for an ABfit analysis with regularision.
}
\examples{
opts <- abfit_reg_opts(ppm_left = 4.2, noise_region = c(-1, -3))
}
