% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{venus}
\alias{venus}
\title{Venus craters}
\format{
A data frame with 967 rows and 4 variables:
\describe{
  \item{name}{name of the crater (if named).}
  \item{diameter}{diameter of the crater (in km).}
  \item{theta}{longitude angle \eqn{\theta \in [0, 2\pi)} of the
  crater center.}
  \item{phi}{latitude angle \eqn{\phi \in [-\pi/2, \pi/2]} of the
  crater center.}
}
}
\source{
\url{https://web.archive.org/web/20240221073126/https://astrogeology.usgs.gov/search/map/Venus/venuscraters}
}
\usage{
venus
}
\description{
Craters on Venus from the
\href{https://web.archive.org/web/20240221073126/https://astrogeology.usgs.gov/search/map/Venus/venuscraters}{
USGS Astrogeology Science Center}.
}
\details{
The \eqn{(\theta, \phi)} angles are such their associated planetocentric
coordinates are:
\deqn{(\cos(\phi) \cos(\theta), \cos(\phi) \sin(\theta), \sin(\phi))',}{
(cos(\phi) cos(\theta), cos(\phi) sin(\theta), sin(\phi))',}
with \eqn{(0, 0, 1)'} denoting the north pole.

The script performing the data preprocessing is available at
\href{https://github.com/egarpor/sphunif/blob/master/data-raw/venus.R}{
\code{venus.R}}.
}
\examples{
# Load data
data("venus")

# Add Cartesian coordinates
venus$X <- cbind(cos(venus$theta) * cos(venus$phi),
                 sin(venus$theta) * cos(venus$phi),
                 sin(venus$phi))

# Tests
unif_test(data = venus$X, type = c("PCvM", "PAD", "PRt"), p_value = "asymp")
}
\keyword{datasets}
