% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glance.R, R/glance_glm.R
\name{glance.spmodel}
\alias{glance.spmodel}
\alias{glance.splm}
\alias{glance.spautor}
\alias{glance.spglm}
\alias{glance.spgautor}
\title{Glance at a fitted model object}
\usage{
\method{glance}{splm}(x, ...)

\method{glance}{spautor}(x, ...)

\method{glance}{spglm}(x, ...)

\method{glance}{spgautor}(x, ...)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A single-row tibble with columns
\itemize{
\item \code{n} The sample size.
\item \code{p} The number of fixed effects.
\item \code{npar} The number of estimated covariance parameters.
\item \code{value} The optimized value of the fitting function.
\item \code{AIC} The AIC.
\item \code{AICc} The AICc.
\item \code{BIC} The BIC.
\item \code{logLik} The log-likelihood.
\item \code{deviance} The deviance.
\item \code{pseudo.r.squared} The pseudo r-squared.
}
}
\description{
Returns a row of model
summaries from a fitted model object. Glance returns the same number of columns for all models
and estimation methods. If a particular summary is undefined for a model
or estimation method (e.g., likelihood statistics for estimation methods
\code{"sv-wls"} or \code{"sv-cl"} of \code{splm()} objects), \code{NA} is returned for that summary.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
glance(spmod)
}
\seealso{
\code{\link[stats:AIC]{stats::AIC()}} \code{\link[=AICc]{AICc()}} \code{\link[stats:AIC]{stats::BIC()}} \code{\link[=logLik.spmodel]{logLik.spmodel()}} \code{\link[=deviance.spmodel]{deviance.spmodel()}} \code{\link[=pseudoR2]{pseudoR2()}} \code{\link[=tidy.spmodel]{tidy.spmodel()}} \code{\link[=augment.spmodel]{augment.spmodel()}}
}
