% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinter_cv.R
\name{cv.sprinter}
\alias{cv.sprinter}
\title{Running sprinter with cross-validation}
\usage{
cv.sprinter(x, y, num_keep = NULL, square = FALSE, lambda = NULL,
  nlam = 100, lam_min_ratio = ifelse(nrow(x) < ncol(x), 0.01, 1e-04),
  nfold = 5, foldid = NULL)
}
\arguments{
\item{x}{An \code{n} by \code{p} design matrix of main effects. Each row is an observation of \code{p} main effects.}

\item{y}{A response vector of size \code{n}.}

\item{num_keep}{Number of candidate interactions to keep in Step 2. If \code{num_keep} is not specified (as default), it will be set to \code{[n / log n]}.}

\item{square}{Indicator of whether squared effects should be fitted in Step 1. Default to be FALSE.}

\item{lambda}{A user specified list of tuning parameter. Default to be NULL, and the program will compute its own \code{lambda} path based on \code{nlam} and \code{lam_min_ratio}.}

\item{nlam}{The number of \code{lambda} values. Default value is \code{100}.}

\item{lam_min_ratio}{The ratio of the smallest and the largest values in \code{lambda}. The largest value in \code{lambda} is usually the smallest value for which all coefficients are set to zero. Default to be \code{1e-2} in the \code{n} < \code{p} setting.}

\item{nfold}{Number of folds in cross-validation. Default value is 5. If each fold gets too view observation, a warning is thrown and the minimal \code{nfold = 3} is used.}

\item{foldid}{A vector of length \code{n} representing which fold each observation belongs to. Default to be \code{NULL}, and the program will generate its own randomly.}
}
\value{
An object of S3 class "\code{sprinter}".
 \describe{
  \item{\code{n}}{The sample size.}
  \item{\code{p}}{The number of main effects.}
  \item{\code{a0}}{estimate of intercept corresponding to the CV-selected model.}
  \item{\code{compact}}{A compact representation of the selected variables. \code{compact} has three columns, with the first two columns representing the indices of a selected variable (main effects with first index = 0), and the last column representing the estimate of coefficients.}
  \item{\code{fit}}{The whole \code{glmnet} fit object in Step 3.}
  \item{\code{fitted}}{fitted value of response corresponding to the CV-selected model.}
  \item{\code{lambda}}{The sequence of \code{lambda} values used.}
  \item{\code{cvm}}{The averaged estimated prediction error on the test sets over K folds.}
  \item{\code{cvsd}}{The standard error of the estimated prediction error on the test sets over K folds.}
  \item{\code{foldid}}{Fold assignment. A vector of length \code{n}.}
  \item{\code{ibest}}{The index in \code{lambda} that is chosen by CV.}
  \item{\code{call}}{Function call.}
 }
}
\description{
The main cross-validation function to select the best sprinter fit for a path of tuning parameters.
}
\examples{
n <- 100
p <- 200
x <- matrix(rnorm(n * p), n, p)
y <- x[, 1] - 2 * x[, 2] + 3 * x[, 1] * x[, 3] - 4 * x[, 4] * x[, 5] + rnorm(n)
mod <- cv.sprinter(x = x, y = y)

}
\seealso{
\code{\link{predict.cv.sprinter}}
}
