% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsFormulas.R
\name{is.formula}
\alias{is.formula}
\alias{is.one.sided}
\alias{has.nested.terms}
\alias{has.cbind.terms}
\alias{has.crange.terms}
\alias{in.formula}
\alias{sub.formulas}
\title{logical functions for formulas}
\usage{
is.formula(frm)

is.one.sided(frm)

has.nested.terms(frm)

has.cbind.terms(frm)

has.crange.terms(frm)

in.formula(frm, whatsym)

sub.formulas(frm, head)
}
\arguments{
\item{frm}{a formula;}

\item{whatsym}{a symbol to search in the formula;}

\item{head}{the beginning of a sub-formula to extract}
}
\value{
\code{is.formula(frm)}, \code{has.nested.terms(frm)},
\code{has.crange.terms(frm)} and \code{has.cbind.terms(frm)}
returns TRUE if frm is a formula, contains a \code{|} or a
\code{crange} or a \code{cbind} respectively;
\code{in.formula(frm, whatsym)} returns TRUE if the symbol \code{whatsym} is somewhere in 'frm';
\code{sub.formulas(frm, head)} returns a list of all the sub-formulas which contains \code{head}.
}
\description{
The functions \code{is.formula()},
\code{is.one.sided()}, \code{has.nested.terms()},
\code{has.cbind.terms()}, \code{has.crange.terms()},
\code{in.formula()} and \code{sub.formulas()}
performs checks or extract sub-formulas from a given formula.
}
\details{
These formulas are for internal use.
}
\examples{
is.formula( Frequency ~ Intensity * Pitch )
 
has.nested.terms( Level ~ Factor | Level )
 
has.cbind.terms( Frequency ~ cbind(Low,Medium,High) * cbind(Soft, Hard) )
 
has.crange.terms( Frequency ~ crange(Low,High) * cbind(Soft, Hard) )
 
in.formula( Frequency ~ Intensity * Pitch, "Pitch" )
 
sub.formulas( Frequency ~ cbind(Low,Medium,High) * cbind(Soft, Hard), "cbind" )
 


}
