% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.survdnn.R
\name{plot.survdnn}
\alias{plot.survdnn}
\title{Plot survdnn Survival Curves using ggplot2}
\usage{
\method{plot}{survdnn}(
  x,
  newdata = NULL,
  times = 1:365,
  group_by = NULL,
  plot_mean_only = FALSE,
  add_mean = TRUE,
  alpha = 0.3,
  mean_lwd = 1.3,
  mean_lty = 1,
  ...
)
}
\arguments{
\item{x}{A fitted `survdnn` model object.}

\item{newdata}{Optional data frame for prediction (defaults to training data).}

\item{times}{A numeric vector of time points at which to compute survival probabilities.}

\item{group_by}{Optional name of a column in `newdata` used to color and group curves.}

\item{plot_mean_only}{Logical; if `TRUE`, plots only the mean survival curve per group.}

\item{add_mean}{Logical; if `TRUE`, adds mean curves to the individual lines.}

\item{alpha}{Alpha transparency for individual curves (ignored if `plot_mean_only = TRUE`).}

\item{mean_lwd}{Line width for mean survival curves.}

\item{mean_lty}{Line type for mean survival curves.}

\item{...}{Reserved for future use.}
}
\value{
A `ggplot` object.
}
\description{
Visualizes survival curves predicted by a fitted `survdnn` model.
Curves can be grouped by a categorical variable in `newdata` and
optionally display only the group-wise means or overlay them.
}
\examples{
\donttest{
library(survival)
data(veteran)
set.seed(42)
\donttest{
mod <- survdnn(Surv(time, status) ~ age + karno + celltype, data = veteran,
               hidden = c(16, 8), epochs = 100, verbose = FALSE)
plot(mod, group_by = "celltype", times = 1:300)
}
}
}
