% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior_sample}
\alias{prior_sample}
\title{Sample from the joint prior of parameters in a survextrap model}
\usage{
prior_sample(
  mspline,
  coefs_mean = NULL,
  prior_hsd = p_gamma(2, 1),
  prior_hscale,
  smooth_model = "exchangeable",
  prior_loghr = NULL,
  formula = NULL,
  cure = NULL,
  nonprop = NULL,
  newdata = NULL,
  newdata0 = NULL,
  prior_hrsd = NULL,
  prior_cure = NULL,
  prior_logor_cure = NULL,
  nsim = 100
)
}
\arguments{
\item{mspline}{A list of control parameters defining the spline model.

\code{knots}: Spline knots.  If this is not supplied, then the number
of knots is taken from \code{df}, and their location is taken from
equally-spaced quantiles of the observed event times in the
individual-level data.

\code{add_knots}: This is intended
to be used when there are \code{external} data included in the
model.  External data are typically outside the time period
covered by the individual data.  \code{add_knots} would then be chosen
to span the time period covered by the external data, so that the
hazard trajectory can vary over that time.

If there are external data, and both \code{knots} and \code{add_knots} are
omitted, then a default set of knots is chosen to span both the
individual and external data, by taking the quantiles of a vector
defined by concatenating the individual-level event times with
the \code{start} and \code{stop} times in the external data.

\code{df}: Degrees of freedom, i.e. the number of parameters (or basis
terms) intended to result from choosing knots based on quantiles
of the data.  The total number of parameters will then be \code{df}
plus the number of additional knots specified in
\code{add_knots}. \code{df} defaults to 10.  This does not necessarily
overfit, because the function is smoothed through the prior.

\code{degree}: Polynomial degree used for the basis function. The
default is 3, giving a cubic. This can only be changed from 3
if \code{bsmooth} is \code{FALSE}.

\code{bsmooth}: If \code{TRUE} (on by default) the spline is smoother
at the highest knot, by defining the derivative and second derivative
at this point to be zero.}

\item{coefs_mean}{Spline basis coefficients that define the prior
mean for the hazard function. By default, these are set to values
that define a constant hazard function (see
\code{\link{mspline_constant_coefs}}).  They are normalised to
sum to 1 internally (if they do not already).}

\item{prior_hsd}{Gamma prior for the standard deviation that
controls the variability over time (or smoothness) of the hazard
function.  This should be a call to \code{p_gamma()}.  The default is
\code{p_gamma(2,1)}.  See \code{\link{prior_haz_sd}} for a way to
calibrate this to represent a meaningful belief.}

\item{prior_hscale}{Prior for the baseline log hazard scale
parameter (\code{alpha} or \code{log(eta)}).  This should be a call to a
prior constructor function, such as \code{p_normal(0,1)} or
\code{p_t(0,2,2)}.  Supported prior distribution families are normal
(parameters mean and SD) and t distributions (parameters
location, scale and degrees of freedom).  The default is a normal
distribution with mean 0 and standard deviation 20.

Note that \code{eta} is not in itself a hazard, but it is proportional
to the hazard (see the vignette for the full model specification).

"Baseline" is defined by the continuous covariates taking a value
of zero and factor covariates taking their reference level.  To
use a different baseline, the data should be transformed
appropriately beforehand, so that a value of zero has a different
meaning.  For continuous covariates, it helps for both
computation and interpretation to define the value of zero to
denote a typical value in the data, e.g. the mean.}

\item{smooth_model}{The default \code{"random_walk"}, specifies a random walk
prior for the multinomial-logit spline coefficients, based on
logistic distributions.  See the \href{https://chjackson.github.io/survextrap/articles/methods.html}{methods vignette}
for full details.

The alternative \code{"exchangeable"} uses
independent logistic priors on the multinomial-logit spline
coefficients, conditionally on a common smoothing variance
parameter.  Note this is the method explained in the original
survextrap paper (Jackson, BMC Med Res 2023).  The random
walk model is shown to perform better in Timmins et al (2025).

In non-proportional hazards models, setting \code{smooth_model} also
determines whether an exchangeable or random walk model is used for the
non-proportionality parameters (\eqn{\delta}).}

\item{prior_loghr}{Priors for log hazard ratios.  This should be a
call to \code{p_normal()} or \code{p_t()}.  A list of calls can also be
provided, to give different priors to different coefficients,
where the name of each list component matches the name of the
coefficient, e.g.  \code{list("age45-59" = p_normal(0,1), "age60+" = p_t(0,2,3))}

The default is \code{p_normal(0,2.5)} for all coefficients.}

\item{formula}{A model formula with no response, defining the
covariates on the hazard scale.}

\item{cure}{A model formula with no response, giving any covariates
on the cure proportion.}

\item{nonprop}{A model formula with no response, defining any
covariates affecting the spline basis coefficients, which gives
a nonproportional hazards model.}

\item{newdata}{A data frame with one row, containing variables in
the model formulae.  Samples will then be drawn, for any
covariate-dependent parameters, with covariates set to the
values given here.}

\item{newdata0}{A data frame with one row, containing "reference"
values of variables in the model formulae.  The hazard ratio
between the hazards at \code{newdata} and \code{newdata0} will
be returned.}

\item{prior_hrsd}{Prior for the standard deviation parameters that
smooth the non-proportionality effects over time in
non-proportional hazards models.  This should be a call to
\code{p_gamma()} or a list of calls to \code{p_gamma()} with one component
per covariate, as in \code{prior_loghr}.  See
\code{\link{prior_hr_sd}} for a way to calibrate this to
represent a meaningful belief.}

\item{prior_cure}{Prior for the baseline cure probability.  This should be a
call to \code{p_beta()}.  The default is a uniform prior, \code{p_beta(1,1)}.
Baseline is defined by the mean of continuous covariates and the reference
level of factor covariates.}

\item{prior_logor_cure}{Priors for log odds ratios on cure probabilities.
This should be a call to \code{p_normal()} or \code{p_t()}.  The default is
\code{p_normal(0,2.5)}.}

\item{nsim}{Number of simulations to draw}
}
\value{
\code{prior_sample_hazard} returns a data frame of the
samples, and \code{plot_prior_hazard} generates a plot.  No
customisation options are provided for the plot function, which
is just intended as a quick check.

A list with components:

\code{alpha}: Baseline log hazard scale parameter (\code{log(eta)} in the notation of the manual). For models with covariates, this is at the covariate values supplied in \code{X}, or at zero if \code{X} is not supplied.

\code{hscale}: Baseline hazard scale parameter (\code{eta}).

\code{coefs}: Spline coefficients. For non-proportional hazards model with covariates, these are returned at the suppled value of \code{X}, or at values of zero if \code{X} is not supplied.

\code{beta}: Multinomial logit-transformed spline coefficients.

\code{hsd}: Smoothing standard deviation for spline coefficients.

If \code{X0} is supplied, then \code{alpha0}, \code{hscale0}, \code{beta0}, \code{coefs0} are also returned, representing reference covariate values.

\code{pcure} is returned in cure models (the cure probability).
}
\description{
Draws a sample from the joint prior distribution of the parameters
governing a survextrap model for given covariates.  This is used,
for example, in \code{\link{prior_sample_hazard}}, to visualise the
prior distribution around hazard curves implied by a particular
M-spline model and parameter priors.
}
