% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cate.R
\name{cate_link}
\alias{cate_link}
\title{Conditional Relative Risk estimation}
\usage{
cate_link(
  treatment,
  link = "identity",
  response_model,
  propensity_model,
  importance_model,
  contrast = c(1, 0),
  data,
  nfolds = 5,
  type = "dml1",
  ...
)
}
\arguments{
\item{treatment}{formula specifying treatment and variables to condition on}

\item{link}{Link function}

\item{response_model}{SL object}

\item{propensity_model}{SL object}

\item{importance_model}{SL object}

\item{contrast}{treatment contrast (default 1 vs 0)}

\item{data}{data.frame}

\item{nfolds}{Number of folds}

\item{type}{'dml1' or 'dml2'}

\item{...}{additional arguments to SuperLearner}
}
\value{
cate.targeted object
}
\description{
Conditional average treatment effect estimation via Double Machine Learning
}
\examples{
# Example 1:
sim1 <- function(n=1e4,
                 seed=NULL,
                 return_model=FALSE, ...){
suppressPackageStartupMessages(require("lava"))
if (!is.null(seed)) set.seed(seed)
m <- lava::lvm()
distribution(m, ~x) <- gaussian.lvm()
distribution(m, ~v) <- gaussian.lvm(mean = 10)
distribution(m, ~a) <- binomial.lvm("logit")
regression(m, "a") <- function(v, x){.1*v + x}
distribution(m, "y") <- gaussian.lvm()
regression(m, "y") <- function(a, v, x){v+x+a*x+a*v*v}
if (return_model) return(m)
lava::sim(m, n = n)
}

if (require("SuperLearner",quietly=TRUE)) {
  d <- sim1(n = 1e3, seed = 1)
  e <- cate_link(data=d,
           type = "dml2",
           treatment = a ~ v,
           response_model = y~ a*(x + v + I(v^2)),
           importance_model = SL(D_ ~ v + I(v^2)),
           nfolds = 10)
  summary(e) # the true parameters are c(1,1)
}
}
\author{
Klaus Kähler Holst & Andreas Nordland
}
