% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_pp_adverse_events.R
\name{tm_g_pp_adverse_events}
\alias{tm_g_pp_adverse_events}
\title{teal Module: Patient Profile Adverse Events Table and Plot}
\usage{
tm_g_pp_adverse_events(
  label,
  dataname = "ADAE",
  parentname = "ADSL",
  patient_col = "USUBJID",
  aeterm = NULL,
  tox_grade = NULL,
  causality = NULL,
  outcome = NULL,
  action = NULL,
  time = NULL,
  decod = NULL,
  font_size = c(12L, 12L, 25L),
  plot_height = c(700L, 200L, 2000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{patient_col}{(\code{character})\cr name of patient ID variable.}

\item{aeterm}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AETERM} variable from \code{dataname}.}

\item{tox_grade}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AETOXGR} variable from \code{dataname}.}

\item{causality}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AEREL} variable from \code{dataname}.}

\item{outcome}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AEOUT} variable from \code{dataname}.}

\item{action}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AEACN} variable from \code{dataname}.}

\item{time}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{ASTDY} variable from \code{dataname}.}

\item{decod}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{AEDECOD} variable from \code{dataname}.}

\item{font_size}{(\code{numeric})\cr numeric vector of length 3 of current, minimum and maximum font size values.}

\item{plot_height}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces an adverse events table and \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} type plot using ADaM datasets.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators::
\itemize{
\item \code{plot} (\code{ggplot})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_g_pp_adverse_events(
   ..., # arguments for module
   decorators = list(
     plot = teal_transform_module(...) # applied only to `plot` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\examples{
library(nestcolor)
library(dplyr)

data <- teal_data()
data <- within(data, {
  ADAE <- tmc_ex_adae
  ADSL <- tmc_ex_adsl \%>\%
    filter(USUBJID \%in\% ADAE$USUBJID)
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

ADSL <- data[["ADSL"]]
ADAE <- data[["ADAE"]]

app <- init(
  data = data,
  modules = modules(
    tm_g_pp_adverse_events(
      label = "Adverse Events",
      dataname = "ADAE",
      parentname = "ADSL",
      patient_col = "USUBJID",
      plot_height = c(600L, 200L, 2000L),
      aeterm = choices_selected(
        choices = variable_choices(ADAE, "AETERM"),
        selected = "AETERM"
      ),
      tox_grade = choices_selected(
        choices = variable_choices(ADAE, "AETOXGR"),
        selected = "AETOXGR"
      ),
      causality = choices_selected(
        choices = variable_choices(ADAE, "AEREL"),
        selected = "AEREL"
      ),
      outcome = choices_selected(
        choices = variable_choices(ADAE, "AEOUT"),
        selected = "AEOUT"
      ),
      action = choices_selected(
        choices = variable_choices(ADAE, "AEACN"),
        selected = "AEACN"
      ),
      time = choices_selected(
        choices = variable_choices(ADAE, "ASTDY"),
        selected = "ASTDY"
      ),
      decod = NULL
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQ7sxs7Pyo1KyBrhD8UKRQ+kZc1AD68YnWSplJhjoA7rSkABa0EOEJULg6IEo6OgCCACKNTsk6pDAEaXAAHmlQ8XD1Tc0AygAyHV09-YP8otQ6AKQAfCujDca01OSM7A7jDgBCAFIAks2r5StjbQAkR6eXzUEAvkEAVkTlaQDWcFYokqiRs+X4cGMUGEpDSBH4tFEPR+f0BwOA0HgINycgAurEWlMOrlgMAFGAiZMKXiCRAWm0SVUyRSGS4wLTYmhUB1ysV2KNcjoALw6XK4UZ8IQiUQinRS4RiAUQBoNLppADmaXQC20jFEcF62jIIK2quoUHocGWotZ-D1Bp0TmNpFEFIlKtVDVyWN0tsprXZHq9DVQLAopF9ctZE2peDNoYStAj8KINp0FOe5yu7oTOkiRDhJTgtA1JVIcoI7AAbAAGWuTGoAJnrjZ0LdbcmDIagcH2MErJV+BDEaQNInUcH4ypDqoIQ5kYjlmhYtEtInhC5HILZNVZTlsTiwAFkKV28w1x3BJ-xo5SD0fT2A8+fPV7SEQBhrmJDB8PR1eN4zrOOjzv+sqiiujBrvQG5gYuO6Bnu962AA8gAGgA4lgZ7drOgHkLe-ptGhWE4c+b6qq+s6yIIojcMUrB-ghY7WtehHATRW5LpBq7roa8Hbuwu4ZveWBOHG1EgQRU53m04lxi+eGqkQgi+EQ8DMdurEThxF6gdxEE6FBMFwYZwlIaJbSoQ4ti4fpMlEVZTg2XZFGzlJXpQBYJBaQBbFAfpgk8cZfGwQJ5kifujQAMIAHL2ZRXqOXJTixQl7khp5qoaJporBaIOnsVOnEhgVy5hWZ4EWW0yGNOMtjNAAmolIE6ClxENc1FJKXmkLEE5cUOJM1KUUEDRBEEtDGDo7DlPs3kaNo1g2HUnqiGUECsI06DsNyDyCLQNT7QajB6h8ShgO8eJAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQ7sxs7Pyo1KyBrhD8UKRQ+kZc1AD68YnWSplJhjoA7rSkABa0EOEJULg6IEo6OgCCACKNTsk6pDAEaXAAHmlQ8XD1Tc0AygAyHV09-YP8otQ6AKQAfCujDca01OSM7A7jDgBCAFIAks2r5StjbQAkR6eXzUEAvkEAVkTlaQDWcFYokqiRs+X4cGMUGEpDSBH4tFEPR+f0BwOA0HgINycgAurEWlMOrlgMAFGAiZMKXiCRAWm0SVUyRSGS4wLTYmhUB1ysV2KNcjoALw6XK4UZ8IQiUQinRS4RiAUQBoNLppADmaXQC20jFEcF62jIIK2quoUHocGWotZ-D1Bp0TmNpFEFIlKtVDVyWN0tsprXZHq9DVQLAopF9ctZE2peDNoYStAj8KINp0FOe5yu7oTOkiRDhJTgtA1JVIcoI7AAbAAGWuTGoAJnrjZ0LdbcmDIagcH2MErJV+BDEaQNInUcH4ypDqoIQ5kYjlmhYtEtInhC5HILZNVZTlsTiwAFkKV28w1x3BJ-xo5SD0fT2A8+fPV7SEQBhrmJDB8PR1eN4zrOOjzv+sqiiujBrvQG5gYuO6Bnu962AA8gAGgA4lgZ7drOgHkLe-ptGhWE4c+b6qq+s6yIIojcMUrB-ghY7WtehHATRW5LpBq7roa8Hbuwu4ZveWBOHG1EgQRU53m04lxi+eGqkQgi+EQ8DMdurEThxF6gdxEE6FBMFwYZwlIaJbSoQ4ti4fpMlEVZTg2XZFGzlJXpQBYJBaQBbFAfpgk8cZfGwQJ5kifujQAMIAHL2ZRXqOXJTixQl7khp5qoaJporBaIOnsVOnEhgVy5hWZ4EWW0yGNOMtjNAAmolIE6ClxENc1FJKXmkLEE5cUOJM1KUUEDRBEEtDGDo7DlPs3kaNo1g2HUnqiGUECsI06DsNyDyCLQNT7QajB6h8ShgO8eJAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

