% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tic_auc.R
\name{tic_auc}
\alias{tic_auc}
\title{Return area under curve from time-intensity data}
\usage{
tic_auc(data, timevar, intensityvar, AUCmax = NULL, plotresult = FALSE)
}
\arguments{
\item{data}{A dataframe with time and intensity values as columns.}

\item{timevar}{A character string (in quotes) with the dataframe column name for the time variable.}

\item{intensityvar}{A character string (in quotes) with dataframe column name for the intensity variable.}

\item{AUCmax}{A number - the maximum time that area under the curve is measured until.}

\item{plotresult}{TRUE or FALSE to determine whether a plot of the results is generated.}
}
\value{
Area under the curve. Depending on the plotresult argument can also
return a plot of the raw data.
}
\description{
This function returns area under curve from raw time intensity curves using
the trapezoid method. It is recommended that plotresult is set to TRUE in the
first instance to visually confirm the analysis.
}
\details{
A plot of the data is generated and a dataframe with the results is returned.
}
\examples{

# Example usage:

# Generating simulated data
set.seed(123)
example_data <- data.frame(time = seq(0, 82, by = 0.25))
random_vals <- sample(1:10, nrow(example_data), replace = TRUE)
example_data$regionA_intensity <- log(example_data$time + 1) * 50 -
  example_data$time * 2 + random_vals
example_data$regionB_intensity <- log(example_data$time + 7, base = 10) *
  80 - example_data$time * 1.5 + random_vals

# Example with defaults:

tic_auc(data = example_data, timevar = "time", intensityvar = "regionA_intensity")

# Example with additional arguments:

tic_auc(data = example_data, timevar = "time", intensityvar = "regionA_intensity",
                   AUCmax = 30, plotresult = TRUE)


}
