% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getQuickstat.R
\name{getQuickstat}
\alias{getQuickstat}
\title{getQuickstat}
\usage{
getQuickstat(
  key = NULL,
  program = NULL,
  data_item = NULL,
  sector = NULL,
  group = NULL,
  commodity = NULL,
  category = NULL,
  domain = NULL,
  geographic_level = NULL,
  state = NULL,
  county = NULL,
  year = NULL,
  geometry = FALSE,
  lower48 = FALSE,
  weighted_by_area = FALSE
)
}
\arguments{
\item{key}{your USDA api key. Get one at https://quickstats.nass.usda.gov/api - string}

\item{program}{program field - string}

\item{data_item}{data_item field - string}

\item{sector}{sector field - string}

\item{group}{group field - string}

\item{commodity}{commodity field - string}

\item{category}{category field - string}

\item{domain}{domain field - string}

\item{geographic_level}{geographic_level field - string}

\item{state}{state field - either a string or character vector with multiple states}

\item{county}{county field - either a string or character vector with multiple states}

\item{year}{year field - string}

\item{geometry}{geometry field (TRUE or FALSE), set to TRUE if you would like a simple features (SF) geometry field included.
Only works when geographic_level is set to 'COUNTY' or 'STATE'}

\item{lower48}{limit data to the lower 48 states? - TRUE or FALSE}

\item{weighted_by_area}{option to mutate a new column that takes the target ('Value') and divides it by the square miles in that state or county; only works when GEOMETRY = TRUE - TRUE or FALSE}
}
\description{
Get values from USDA Quick Stats in a dataframe
with optional sf (simple features) geometry field
}
\note{
Go to the webpage https://quickstats.nass.usda.gov/. As a best practice, select the items in these fields and test that that data item
   exists in the browser before using those parameters in this function. When you have a dataset that works, enter those values in the
   function as parameters. Ideally, only enter values for your key obviously, then PROGRAM, DATA_ITEM, GEOGRAPHIC_LEVEL and then if
   necessary, DOMAIN, STATE, COUNTY or YEAR.
}
\examples{
\dontrun{
getQuickstat(
  key = "your_key",
  program = "CENSUS",
  data_item = "CROP TOTALS - OPERATIONS WITH SALES",
  geographic_level = "COUNTY",
  domain = "TOTAL",
  year = "2017",
  state = NULL,
  geometry = T,
  lower48 = T
)
}

}
