% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_property.R
\name{tw_get_p1}
\alias{tw_get_p1}
\title{Get Wikidata property of an item as a character vector of the same length as input}
\usage{
tw_get_p1(
  id,
  p,
  latest_start_time = FALSE,
  language = tidywikidatar::tw_get_language(),
  id_df = NULL,
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 0
)
}
\arguments{
\item{id}{A character vector, must start with Q, e.g. "Q254" for Wolfgang Amadeus Mozart.}

\item{p}{A character vector, a property. Must always start with the capital letter "P", e.g. "P31" for "instance of".}

\item{latest_start_time}{Logical, defaults to FALSE. If TRUE, returns the property that has the most recent start time ("P580") as qualifier. If no such qualifier is found, then it is ignored.}

\item{language}{Defaults to language set with \code{tw_set_language()}; if not set, "en". Use "all_available" to keep all languages. For available language values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{id_df}{Default to NULL. If given, it should be a dataframe typically generated with \code{tw_get_()}, and is used instead of calling Wikidata or replying on cache.}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{cache_connection}{Defaults to NULL. If NULL, and caching is enabled, \code{tidywikidatar} will use a local sqlite database. A custom connection to other databases can be given (see vignette \code{caching} for details).}

\item{disconnect_db}{Defaults to TRUE. If FALSE, leaves the connection to cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}
}
\value{
A character vector of the same length as the input.
}
\description{
This function wraps \code{tw_get_p()}, but always sets \code{only_first} and \code{preferred} to TRUE in order to give back always a character vector.
}
\examples{
tw_get_p1(id = "Q180099", "P26")
}
