% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{render_report}
\alias{render_report}
\title{Render a report (R Markdown / Quarto) from the internal template}
\usage{
render_report(
  df,
  meta = list(river = NA, period = NA),
  output_file = "wq_report.html",
  output_dir = tempdir(),
  template = system.file("templates", "report_rmd.Rmd", package = "tikatuwq")
)
}
\arguments{
\item{df}{Data frame with input data used by the template}

\item{meta}{Named list with contextual metadata (e.g., river, period)}

\item{output_file}{Output file name (default 'wq_report.html')}

\item{output_dir}{Directory where the file will be written (default tempdir())}

\item{template}{Path to the internal template file}
}
\value{
Invisible character path to the generated report
}
\description{
By default, writes to a temporary directory to comply with CRAN policies.
The function returns the full path to the generated file.
}
