% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iet_lamparelli.R
\name{iet_lamparelli}
\alias{iet_lamparelli}
\title{Trophic State Index (Lamparelli)}
\usage{
iet_lamparelli(
  tp = NULL,
  chla = NULL,
  sd = NULL,
  ambiente = c("rio", "reservatorio"),
  .keep_ids = FALSE
)
}
\arguments{
\item{tp}{Numeric total phosphorus (mg/L) \strong{or} a data.frame containing
columns named \code{tp} (ug/L) or \code{p_total} (mg/L), \code{chla} or
\code{clorofila} (ug/L), and \code{sd} or \code{secchi} (m). If a
data.frame is provided, \code{chla} and \code{sd} must be \code{NULL}.}

\item{chla}{Numeric chlorophyll-a (ug/L).}

\item{sd}{Numeric Secchi disk depth (m).}

\item{ambiente}{Character, environment type: 'rio' or 'reservatorio'.}

\item{.keep_ids}{Logical; when a data.frame is provided, bind back common ID
columns (\code{rio}, \code{ponto}, \code{data}, \code{lat}, \code{lon}).
Default FALSE (preserves historical behaviour).}
}
\value{
Data frame with IET components and overall \code{IET_Lamp}.
}
\description{
Computes components of the Lamparelli trophic state index (TSI/IET) from
total phosphorus, chlorophyll-a, and Secchi depth, and returns the overall
Lamparelli index as the row-wise mean of available components.

You can also pass a data.frame as the first argument (see Details).
}
\details{
Minimal, pragmatic implementation; confirm coefficients/thresholds for your
region before regulatory use. Character inputs like "3,2" or "<0,1" are
safely converted. If only \code{p_total} (mg/L) is present, it is converted
to \code{tp} in ug/L via \code{tp = p_total * 1000}.
}
