% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ctx.R
\name{tiledb_is_supported_fs}
\alias{tiledb_is_supported_fs}
\title{Query if a TileDB backend is supported}
\usage{
tiledb_is_supported_fs(scheme, object = tiledb_get_context())
}
\arguments{
\item{scheme}{URI string scheme ("file", "hdfs", "s3")}

\item{object}{\code{tiledb_ctx} object}
}
\value{
TRUE if tiledb backend is supported, FALSE otherwise
}
\description{
The scheme corresponds to the URI scheme for TileDB resouces.
}
\details{
Ex:
\itemize{
\item \verb{\{file\}:///path/to/file}
\item \verb{\{hdfs\}:///path/to/file}
\item \verb{\{s3\}://hostname:port/path/to/file}
}
}
\examples{
\dontshow{
ctx <- tiledb_ctx(limitTileDBCores())
}
tiledb_is_supported_fs("file")
tiledb_is_supported_fs("s3")

}
